/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.refexpr;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.valueholder.IValueHolder;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class MultiSymbolReferenceExpr
implements IReferenceExpr {
    private String fullName;
    private SourceRange range;
    private ISymbolPageIdx symbolIdx;

    public MultiSymbolReferenceExpr(String string, SourceRange sourceRange) {
        this.range = sourceRange;
        this.fullName = string;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState, ReferenceOperation referenceOperation) {
        int n;
        boolean bl = this.fullName.endsWith("-");
        if (!bl && !this.fullName.endsWith("+")) {
            evaluationState.diagnosticMgr.add(new AsmError("Missing direction on multilabel reference '" + this.fullName + "'", this.range));
            return;
        }
        int n2 = this.fullName.length() - 1;
        if (bl) {
            n = 0;
            --n2;
            while (n2 > 0 && this.fullName.charAt(n2) == '-') {
                --n;
                --n2;
            }
        } else {
            n = 1;
            --n2;
            while (n2 > 0 && this.fullName.charAt(n2) == '+') {
                ++n;
                --n2;
            }
        }
        String string = this.fullName.substring(0, n2 + 1);
        this.symbolIdx = evaluationState.scopeMgr.getCurrentScope().getMultiSymbol(string, n);
        if (this.symbolIdx == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Unknown symbol '" + this.fullName + "'", this.range));
        }
    }

    @Override
    public IValueHolder getValueHolder(EvaluationState evaluationState) {
        return this.symbolIdx.getValueHolder();
    }

    public String toString() {
        return "MultiLabelReference(" + this.fullName + ")";
    }

    @Override
    public SourceRange getSourceRange() {
        return this.range;
    }
}

