/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.stmt;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.valueholder.FunctionVariableValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolInitializer;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class VariableDeclaration
extends StmtNode {
    private String name;
    private ExprNode initValueExpr = null;
    private boolean isFunctionMode;
    private ISymbolPageIdx symbolIdx;

    public VariableDeclaration(String string, ExprNode exprNode, boolean bl, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.initValueExpr = exprNode;
        this.isFunctionMode = bl;
    }

    @Override
    public void executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.scopeMgr.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return;
        }
        ISymbolInitializer iSymbolInitializer = this.isFunctionMode ? FunctionVariableValueHolder.initializer : VariableValueHolder.initializer;
        this.symbolIdx = symbolScope.define(string, iSymbolInitializer);
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        if (this.symbolIdx == null) {
            return;
        }
        if (this.initValueExpr != null) {
            this.initValueExpr.executePrepass(evaluationState);
        }
        this.symbolIdx.setStatus(SymbolStatus.defined);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        IValueHolder iValueHolder = this.symbolIdx.getValueHolder();
        NullValue nullValue = this.initValueExpr == null ? NullValue.instance : this.initValueExpr.evaluate(evaluationState);
        iValueHolder.set(nullValue, evaluationState, this.range);
        return nullValue;
    }

    public String toString() {
        return "VarDeclaration";
    }
}

