/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function;

import java.util.Arrays;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.IFunction;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class StaticToObjectFunction
implements IFunction {
    private IFunction staticFunc;

    public StaticToObjectFunction(IFunction iFunction) {
        this.staticFunc = iFunction;
    }

    private Value[] adaptArguments(Value[] valueArray) {
        return Arrays.copyOfRange(valueArray, 1, valueArray.length);
    }

    @Override
    public String getName() {
        return this.staticFunc.getName();
    }

    @Override
    public Integer getNoOfArguments() {
        return this.staticFunc.getNoOfArguments() + 1;
    }

    @Override
    public Value getInvalidResult(Value[] valueArray) {
        return this.staticFunc.getInvalidResult(this.adaptArguments(valueArray));
    }

    @Override
    public boolean handlesInvalidArguments() {
        return this.staticFunc.handlesInvalidArguments();
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.staticFunc.execute(this.adaptArguments(valueArray), evaluationState, sourceRange);
    }
}

