/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.table;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.IFunction;
import kickass.pass.function.StaticToObjectFunction;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.function.table.FunctionTable;
import kickass.state.namespace.Namespace;

public class NamespaceFunctionTable
extends FunctionTable {
    private Namespace namespace;

    public NamespaceFunctionTable(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public IFunction get(String string, int n) {
        IFunctionSelector iFunctionSelector = this.namespace.getFunctions().get(string);
        if (iFunctionSelector == null) {
            return null;
        }
        int n2 = n - 1;
        Function function = iFunctionSelector.getFunction(n2);
        if (function == null) {
            return null;
        }
        return new StaticToObjectFunction(function);
    }

    @Override
    public IFunction getOrError(String string, int n, SourceRange sourceRange) {
        IFunctionSelector iFunctionSelector = this.namespace.getFunctions().get(string);
        if (iFunctionSelector == null) {
            throw new AsmErrorException("Unknown function '" + string + "'.", sourceRange);
        }
        int n2 = n - 1;
        Function function = iFunctionSelector.getFunction(n2);
        if (function == null) {
            throw new AsmErrorException("Invalid no of args for function '" + string + "'.", sourceRange);
        }
        return new StaticToObjectFunction(function);
    }
}

