/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.functionnode;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.parsing.sourcelocation.misc.StringRangeList;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.functionnode.FunctionDirective;
import kickass.pass.functionnode.FunctionNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;

public class ForEachFDirective
extends FunctionDirective {
    private StringRange enumerationId = null;
    private StringRangeList varIds;
    private List<ExprNode> iterExprs;
    private ExprNode ifExpr;
    private FunctionNode body;
    private SymbolScope countVarScope;
    private SymbolScope innerScope;
    private ISymbolPageIdx enumeratorSymbolPageIdx;
    private ISymbolPageIdx[] iterVarSymbolPageIdxs;

    public ForEachFDirective(StringRangeList stringRangeList, List<ExprNode> list, ExprNode exprNode, FunctionNode functionNode, SourceRange sourceRange) {
        super(sourceRange);
        if (stringRangeList.size() > list.size()) {
            this.enumerationId = (StringRange)stringRangeList.get(0);
            stringRangeList = stringRangeList.subList(1, stringRangeList.size());
        }
        this.varIds = stringRangeList;
        this.iterExprs = list;
        this.ifExpr = exprNode;
        this.body = functionNode;
    }

    @Override
    public FunctionNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.iterExprs.size() == 0) {
            evaluationState.diagnosticMgr.add(new AsmError("You must supply an iterator", this.range));
        } else if (this.varIds.size() != this.iterExprs.size()) {
            evaluationState.diagnosticMgr.add(new AsmError("Number of itererators does not match the number of variables", this.iterExprs.getLast().getSourceRange()));
        }
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        this.countVarScope = new SymbolScope(symbolScope, null);
        this.innerScope = new SymbolScope(this.countVarScope, new SymbolTable());
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        if (this.enumerationId != null) {
            this.enumeratorSymbolPageIdx = this.countVarScope.defineErrorIfExist(this.enumerationId.string, VariableValueHolder.initializer, evaluationState, "Symbol already defined", this.enumerationId.range);
        }
        int n = 0;
        this.iterVarSymbolPageIdxs = new ISymbolPageIdx[this.varIds.size()];
        for (StringRange stringRange : this.varIds) {
            this.iterVarSymbolPageIdxs[n++] = this.countVarScope.defineErrorIfExist(stringRange.string, VariableValueHolder.initializer, evaluationState, "Symbol already defined", stringRange.range);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public FunctionNode executePrepass(EvaluationState evaluationState) {
        for (int i = 0; i < this.iterExprs.size(); ++i) {
            this.iterExprs.get(i).executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope);
        if (this.enumeratorSymbolPageIdx != null) {
            this.enumeratorSymbolPageIdx.setStatus(SymbolStatus.defined);
        }
        for (ISymbolPageIdx iSymbolPageIdx : this.iterVarSymbolPageIdxs) {
            iSymbolPageIdx.setStatus(SymbolStatus.defined);
        }
        if (this.ifExpr != null) {
            this.ifExpr.executePrepass(evaluationState);
        }
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.countVarScope.getParent());
        return this;
    }

    @Override
    public void executeFunctionPass(EvaluationState evaluationState) {
        int n;
        IValueIterator[] iValueIteratorArray = new IValueIterator[this.iterExprs.size()];
        for (n = 0; n < this.iterExprs.size(); ++n) {
            Value value = this.iterExprs.get(n).evaluate(evaluationState);
            iValueIteratorArray[n] = value.getIterator(this.range);
        }
        n = 0;
        while (true) {
            block9: {
                block8: {
                    if (this.enumerationId != null) {
                        IValueHolder iValueHolder = this.enumeratorSymbolPageIdx.getValueHolder();
                        iValueHolder.set(new NumberValue(n), evaluationState, this.range);
                    }
                    boolean bl = false;
                    int n2 = 0;
                    for (int i = 0; i < this.iterExprs.size(); ++i) {
                        SourceRange sourceRange = this.iterExprs.get(i).getSourceRange();
                        IValueIterator iValueIterator = iValueIteratorArray[i];
                        boolean bl2 = iValueIterator.hasNext();
                        NullValue nullValue = bl2 ? iValueIterator.next(sourceRange) : NullValue.instance;
                        bl |= bl2;
                        IValueHolder iValueHolder = this.iterVarSymbolPageIdxs[n2++].getValueHolder();
                        iValueHolder.set(nullValue, evaluationState, this.range);
                    }
                    if (!bl) break;
                    if (this.ifExpr == null) break block8;
                    Value value = this.ifExpr.evaluate(evaluationState);
                    if (value.isInvalid()) {
                        throw new AsmErrorException("Can't evaluate filter in first pass", this.range);
                    }
                    if (!value.getBoolean(this.range)) break block9;
                }
                this.body.executeFunctionPass(evaluationState);
            }
            ++n;
        }
    }
}

