/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.misc.ToStringParams;
import kickass.state.EvaluationState;

public class BinaryFileValue
extends ImmutableValue {
    public static BinaryFileValue invalid = new BinaryFileValue();
    private static final String c64FileToken = "C64FILE";
    private int offset = 0;
    private byte[] file;
    FunctionTable functions = new StdFunctionTable(BinaryFileValue.getStandardFunctions());

    private BinaryFileValue() {
        this.setInvalid();
    }

    public BinaryFileValue(byte[] byArray, BlockData blockData) {
        this.file = byArray;
        this.offset = blockData.offset;
        for (Block block : blockData.blocks) {
            this.functions.add(new BlockGetFunction("get" + block.name, block, false));
            this.functions.add(new BlockGetFunction("uget" + block.name, block, true));
            this.functions.add(new BlockSizeFunction("get" + block.name + "Size", block));
        }
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public void getString(ToStringParams toStringParams) {
        toStringParams.sb().append(this.isInvalid() ? "<<Invalid Binary file>>" : "Binary file");
    }

    @Override
    public String getType() {
        return "Binary file";
    }

    public static BlockData templateToBlocks(String string, int n, SourceRange sourceRange) {
        BlockData blockData = BinaryFileValue.parseBlocks(string, sourceRange);
        Comparator<Block> comparator = new Comparator<Block>(){

            @Override
            public int compare(Block block, Block block2) {
                if (block.start == block2.start) {
                    return 0;
                }
                return block.start < block2.start ? -1 : 1;
            }
        };
        Collections.sort(blockData.blocks, comparator);
        Block block = null;
        for (Block block2 : blockData.blocks) {
            if (block != null) {
                block.length = block2.start - block.start;
            }
            block = block2;
        }
        if (block != null) {
            block.length = n - blockData.offset - block.start;
        }
        Block block3 = new Block();
        block3.name = "";
        block3.start = 0;
        block3.length = n - blockData.offset;
        blockData.blocks.add(block3);
        return blockData;
    }

    private static BlockData parseBlocks(String string, SourceRange sourceRange) {
        BlockData blockData = new BlockData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().equals(c64FileToken)) {
                blockData.offset = 2;
                continue;
            }
            int n = string2.indexOf(61);
            if (n < 0) {
                throw new AsmErrorException("Invalid token in template: '" + string2 + "'", sourceRange);
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            int n2 = 0;
            try {
                int n3 = 10;
                if (string4.charAt(0) == '$') {
                    n3 = 16;
                    string4 = string4.substring(1);
                }
                n2 = Integer.valueOf(string4, n3);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Invalid address of token : '" + string2 + "'", sourceRange);
            }
            Block block = new Block();
            block.start = n2;
            block.name = string3;
            blockData.blocks.add(block);
        }
        return blockData;
    }

    @Override
    public FunctionTable getFunctions() {
        return this.functions;
    }

    public static class BlockData {
        public int offset = 0;
        public List<Block> blocks = new ArrayList<Block>();
    }

    public static class Block {
        public int start;
        public int length;
        public String name;
    }

    private class BlockGetFunction
    extends Function {
        private Block block;
        private boolean unsigned;

        public BlockGetFunction(String string, Block block, boolean bl) {
            super(string, null, NumberValue.invalid);
            this.block = block;
            this.unsigned = bl;
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
            int n;
            int n2 = 0;
            if (valueArray.length > 2) {
                throw new AsmErrorException("Invalid number of arguments : " + (valueArray.length - 1), sourceRange);
            }
            if (valueArray.length == 2) {
                n2 = valueArray[1].getInt(sourceRange);
            }
            if ((n = this.block.start + n2 + BinaryFileValue.this.offset) < 0 || n >= BinaryFileValue.this.file.length) {
                throw new AsmErrorException("index out of range : " + n2, sourceRange);
            }
            int n3 = BinaryFileValue.this.file[n];
            if (this.unsigned) {
                n3 &= 0xFF;
            }
            return new NumberValue(n3);
        }
    }

    private static class BlockSizeFunction
    extends Function {
        private Block block;

        public BlockSizeFunction(String string, Block block) {
            super(string, 1, NumberValue.invalid);
            this.block = block;
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
            return new NumberValue(this.block.length);
        }
    }
}

