/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.LambdaExpr;
import kickass.pass.function.Function;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.Value;
import kickass.pass.values.interfaces.ICallable;
import kickass.state.EvaluationState;

public class CallableValue
extends Value {
    public static CallableValue invalid = new CallableValue();
    private ICallable callable;
    static FunctionTable functions = new StdFunctionTable(CallableValue.getStandardFunctions());

    private CallableValue() {
        this.setInvalid();
    }

    public CallableValue(ICallable iCallable) {
        this.callable = iCallable;
    }

    @Override
    public String getType() {
        return "CallableValue";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        if (this.isInvalid()) {
            return "<<Invalid CallableValue\u00aa>>";
        }
        return "<CallableValue>";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public boolean isCallable() {
        return this.callable.isCallable();
    }

    @Override
    public boolean isCallable(int n) {
        return this.callable.isCallable(n);
    }

    @Override
    public Value call(int n, Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.callable.call(n, valueArray, evaluationState, sourceRange);
    }

    @Override
    public Value call(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.callable.call(valueArray, evaluationState, sourceRange);
    }

    @Override
    public Value call(EvaluationState evaluationState, SourceRange sourceRange) {
        return this.callable.call(evaluationState, sourceRange);
    }

    @Override
    public Value call(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.callable.call(value, evaluationState, sourceRange);
    }

    @Override
    public Value call(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.callable.call(value, value2, evaluationState, sourceRange);
    }

    @Override
    public List<String> getArgumentNames() {
        return this.callable.getArgumentNames();
    }

    @Override
    public LambdaExpr getLambdaExpr() {
        return this.callable.getLambdaExpr();
    }

    @Override
    public Integer noOfCallArguments() {
        return this.callable.noOfCallArguments();
    }

    static {
        functions.add(new ValFunction2Arg<CallableValue>("==", BooleanValue.invalid, (callableValue, value, sourceRange) -> BooleanValue.get(callableValue == value)));
        functions.add(new ValFunction2Arg<CallableValue>("!=", BooleanValue.invalid, (callableValue, value, sourceRange) -> BooleanValue.get(callableValue != value)));
        functions.add(new Function("call", null, InvalidValue.instance){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return valueArray[0].call(1, valueArray, evaluationState, sourceRange);
            }
        });
    }
}

