/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.special.ValFunction1Arg;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.special.ValFunctionVarArg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valuerep.ValueRepresentation;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.IteratorValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.LockableValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.StringValue;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.pass.values.misc.ToStringParams;
import kickass.pass.values.valueiterator.StdValueIterator;
import kickass.pass.values.valueiterator.StringIterAdapter;

public class HashtableValue
extends LockableValue {
    private HashMap<String, Value> hashtable = new HashMap();
    private boolean hasInvalidContent = false;
    public static Value invalid = new HashtableValue().setInvalid();
    static FunctionTable functions = new StdFunctionTable(HashtableValue.getStandardFunctions());
    private static List<String> entryFields;

    public HashtableValue addStringValues(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.putValue(entry.getKey(), new StringValue(entry.getValue()));
        }
        return this;
    }

    public ListValue getKeyListValue() {
        ListValue listValue = new ListValue(0);
        for (String string : this.hashtable.keySet()) {
            listValue.add(new StringValue(string));
        }
        return listValue;
    }

    public void putValue(String string, Value value) {
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
        this.hashtable.put(string, value);
    }

    @Override
    public String getType() {
        return "Hashtable";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public void getString(ToStringParams toStringParams) {
        if (this.isInvalid()) {
            toStringParams.sb().append("<<Invalid HashTable>>");
            return;
        }
        if (toStringParams.visited().contains(this)) {
            toStringParams.sb().append("{...}");
            return;
        }
        toStringParams.visited().add(this);
        StringBuilder stringBuilder = toStringParams.sb();
        stringBuilder.append("{");
        ToStringParams toStringParams2 = toStringParams.withIsInsideContainer(true);
        boolean bl = true;
        for (Map.Entry<String, Value> entry : this.hashtable.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            entry.getValue().getString(toStringParams2);
        }
        stringBuilder.append("}");
    }

    public Value createKeysIter() {
        StdValueIterator stdValueIterator = new StdValueIterator(new StringIterAdapter(this.hashtable.keySet().iterator()), () -> this.hasInvalidContent());
        return new IteratorValue(stdValueIterator);
    }

    public Value createEntryIter() {
        final Iterator<Map.Entry<String, Value>> iterator = this.hashtable.entrySet().iterator();
        Iterator<Value> iterator2 = new Iterator<Value>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Value next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                StructValue structValue = new StructValue("entry", entryFields, new Value[]{StringValue.valueOf((String)entry.getKey()), (Value)entry.getValue()});
                return structValue;
            }
        };
        StdValueIterator stdValueIterator = new StdValueIterator(iterator2, () -> this.hasInvalidContent());
        return new IteratorValue(stdValueIterator);
    }

    public Value createValuesIter() {
        return new IteratorValue(new StdValueIterator(this.hashtable.values().iterator(), () -> this.hasInvalidContent()));
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        return null;
    }

    @Override
    public void lock(SourceRange sourceRange) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.hashtable.values()) {
            value.lock(sourceRange);
        }
    }

    static {
        functions.add(new ValFunctionVarArg<HashtableValue>("put", (hashtableValue, valueArray, sourceRange) -> {
            int n = 1;
            while (n < ((Value[])valueArray).length) {
                String string = valueArray[n++].getString((SourceRange)sourceRange);
                if (n >= ((Value[])valueArray).length) {
                    throw new AsmErrorException("Missing value in key-value pair for hash table", (SourceRange)sourceRange);
                }
                Value value = valueArray[n++];
                hashtableValue.putValue(string, value);
            }
            return hashtableValue;
        }));
        functions.add(new ValFunction1Arg<HashtableValue>("size", NumberValue.invalid, (hashtableValue, sourceRange) -> new NumberValue(hashtableValue.hashtable.size())));
        functions.add(new ValFunction1Arg<HashtableValue>("keys", ListValue.invalid, (hashtableValue, sourceRange) -> hashtableValue.getKeyListValue()));
        functions.add(new ValFunction1Arg<HashtableValue>("keyIter", IteratorValue.invalid, (hashtableValue, sourceRange) -> hashtableValue.createKeysIter()));
        functions.add(new ValFunction1Arg<HashtableValue>("valueIter", IteratorValue.invalid, (hashtableValue, sourceRange) -> hashtableValue.createValuesIter()));
        functions.add(new ValFunction1Arg<HashtableValue>("entryIter", IteratorValue.invalid, (hashtableValue, sourceRange) -> hashtableValue.createEntryIter()));
        functions.add(new ValFunction2Arg<HashtableValue>("get", InvalidValue.instance, (hashtableValue, value, sourceRange) -> NullValue.nullIfNull(hashtableValue.hashtable.get(value.getString((SourceRange)sourceRange)))));
        functions.add(new ValFunction2Arg<HashtableValue>("containsKey", BooleanValue.invalid, (hashtableValue, value, sourceRange) -> BooleanValue.get(hashtableValue.hashtable.containsKey(value.getString((SourceRange)sourceRange)))));
        functions.add(new ValFunction2Arg<HashtableValue>("remove", NullValue.instance, (hashtableValue, value, sourceRange) -> NullValue.nullIfNull(hashtableValue.hashtable.remove(value.getString((SourceRange)sourceRange)))));
        entryFields = Arrays.asList("key", "value");
    }
}

