/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.IFunction;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.Value;
import kickass.pass.values.libs.IteratorFunctions;
import kickass.pass.values.valueiterator.IValueIterator;

public class IteratorValue
extends Value {
    public static IteratorValue invalid = new IteratorValue();
    private IValueIterator iterator;
    boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(IteratorValue.getStandardFunctions());

    private IteratorValue() {
        this.setInvalid();
    }

    public IteratorValue(IValueIterator iValueIterator) {
        this.iterator = iValueIterator;
    }

    @Override
    public String getType() {
        return "Iterator";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.iterator.hasInvalidContent();
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        if (this.isInvalid()) {
            return "<<Invalid Iterable>>";
        }
        return "<Iterable>";
    }

    @Override
    public boolean hasIterator() {
        return true;
    }

    @Override
    public IValueIterator getIterator(SourceRange sourceRange) {
        return this.iterator;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    static {
        functions.add(new ValFunction2Arg<IteratorValue>("==", BooleanValue.invalid, (iteratorValue, value, sourceRange) -> BooleanValue.get(iteratorValue == value)));
        functions.add(new ValFunction2Arg<IteratorValue>("!=", BooleanValue.invalid, (iteratorValue, value, sourceRange) -> BooleanValue.get(iteratorValue != value)));
        for (IFunction iFunction : IteratorFunctions.functions) {
            functions.add(iFunction);
        }
    }
}

