/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.IFunction;
import kickass.pass.function.special.ValFunction1Arg;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.special.ValSAction1Arg;
import kickass.pass.function.special.ValSAction2Arg;
import kickass.pass.function.special.ValSAction3Arg;
import kickass.pass.function.special.ValSActionVarArg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valuerep.ListRep;
import kickass.pass.valuerep.ValueRepresentation;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.IteratorValue;
import kickass.pass.values.LockableValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.libs.IteratorFunctions;
import kickass.pass.values.misc.ToStringParams;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.pass.values.valueiterator.StdValueIterator;
import kickass.state.libraries.MathLibrary;

public class ListValue
extends LockableValue {
    public static ListValue invalid = new ListValue();
    private ArrayList<Value> list = new ArrayList();
    boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(ListValue.getStandardFunctions());

    private ListValue() {
        this.setInvalid();
    }

    public ListValue(int n) {
        for (int i = 0; i < n; ++i) {
            this.list.add(NullValue.instance);
        }
    }

    public ListValue(Iterator<Value> iterator) {
        while (iterator.hasNext()) {
            this.list.add(iterator.next());
        }
    }

    public ListValue(IValueIterator iValueIterator, SourceRange sourceRange) {
        while (iValueIterator.hasNext()) {
            this.list.add(iValueIterator.next(sourceRange));
        }
    }

    @Override
    public String getType() {
        return "List";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    public void add(Value value) {
        this.list.add(value);
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
    }

    public void addAll(IValueIterator iValueIterator, SourceRange sourceRange) {
        while (iValueIterator.hasNext()) {
            Value value = iValueIterator.next(sourceRange);
            if (value.isInvalidOrInvalidContent()) {
                this.hasInvalidContent = true;
            }
            this.list.add(value);
        }
    }

    @Override
    public boolean hasIterator() {
        return true;
    }

    @Override
    public IValueIterator getIterator(SourceRange sourceRange) {
        return new StdValueIterator(this.list.iterator(), () -> this.hasInvalidContent);
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        if (valueRepresentation == ListRep.representation) {
            return this.list;
        }
        return null;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public void getString(ToStringParams toStringParams) {
        StringBuilder stringBuilder = toStringParams.sb();
        if (this.isInvalid()) {
            stringBuilder.append("<<Invalid List>>");
            return;
        }
        if (toStringParams.visited().contains(this)) {
            stringBuilder.append("[...]");
            return;
        }
        toStringParams.visited().add(this);
        stringBuilder.append("[");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            this.list.get(i).getString(toStringParams);
        }
        stringBuilder.append("]");
    }

    void checkForOutOfBound(int n, SourceRange sourceRange) throws AsmException {
        if (n < 0 || this.list.size() <= n) {
            throw new AsmErrorException("Index out of bound : " + n, sourceRange);
        }
    }

    public Value createReverseIterator() {
        return new IteratorValue(new StdValueIterator(new ReverseListIterator(this, this.list.listIterator(this.list.size())), () -> this.hasInvalidContent()));
    }

    public Value createIterator() {
        return new IteratorValue(new StdValueIterator(this.list.iterator(), () -> this.hasInvalidContent()));
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
        if (this.isLocked) {
            return;
        }
        if (this.isInvalidOrInvalidContent()) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.list) {
            value.lock(sourceRange);
        }
    }

    static {
        functions.add(new ValSActionVarArg<ListValue>("add", false, (listValue, valueArray, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            for (int i = 1; i < ((Value[])valueArray).length; ++i) {
                listValue.add(valueArray[i]);
            }
        }));
        functions.add(new ValSAction2Arg<ListValue>("addAll", false, (listValue, value, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            listValue.addAll(value.getIterator((SourceRange)sourceRange), (SourceRange)sourceRange);
        }));
        functions.add(new ValFunction2Arg<ListValue>("get", InvalidValue.instance, (listValue, value, sourceRange) -> {
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            return listValue.list.get(n);
        }));
        functions.add(new ValFunction1Arg<ListValue>("getFirst", InvalidValue.instance, (listValue, sourceRange) -> listValue.list.isEmpty() ? NullValue.instance : listValue.list.getFirst()));
        functions.add(new ValFunction1Arg<ListValue>("getLast", InvalidValue.instance, (listValue, sourceRange) -> listValue.list.isEmpty() ? NullValue.instance : listValue.list.getLast()));
        functions.add(new ValFunction1Arg<ListValue>("isEmpty", BooleanValue.invalid, (listValue, sourceRange) -> BooleanValue.get(listValue.list.isEmpty())));
        functions.add(new ValFunction2Arg<ListValue>("==", BooleanValue.invalid, (listValue, value, sourceRange) -> BooleanValue.get(listValue == value)));
        functions.add(new ValFunction2Arg<ListValue>("!=", BooleanValue.invalid, (listValue, value, sourceRange) -> BooleanValue.get(listValue != value)));
        functions.add(new ValSAction3Arg<ListValue>("set", false, (listValue, value, value2, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            if (value.isInvalid()) {
                listValue.setInvalid();
            }
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            listValue.list.set(n, (Value)value2);
            if (value2.isInvalidOrInvalidContent()) {
                listValue.hasInvalidContent = true;
            }
        }));
        functions.add(new ValFunction2Arg<ListValue>("remove", (listValue, value, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            if (value.isInvalid()) {
                listValue.setInvalid();
                return listValue;
            }
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            listValue.list.remove(n);
            return listValue;
        }));
        functions.add(new ValFunction1Arg<ListValue>("iter", IteratorValue.invalid, (listValue, sourceRange) -> new IteratorValue(new StdValueIterator(listValue.list.iterator(), () -> listValue.hasInvalidContent()))));
        functions.add(new ValFunction1Arg<ListValue>("reverseIter", IteratorValue.invalid, (listValue, sourceRange) -> listValue.createReverseIterator()));
        functions.add(new ValFunction1Arg<ListValue>("size", NumberValue.invalid, (listValue, sourceRange) -> new NumberValue(listValue.list.size())));
        functions.add(new ValSAction1Arg<ListValue>("shuffle", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            Collections.shuffle(listValue.list, MathLibrary.getRandomGenerator());
        }));
        functions.add(new ValSAction1Arg<ListValue>("reverse", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            Collections.reverse(listValue.list);
        }));
        functions.add(new ValSAction1Arg<ListValue>("sort", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            ArrayList<Pair<Double, Value>> arrayList = new ArrayList<Pair<Double, Value>>();
            for (Value value : listValue.list) {
                Double d = value.hasDouble() ? value.getDouble((SourceRange)sourceRange) : Double.MAX_VALUE;
                arrayList.add(new Pair<Double, Value>(d, value));
            }
            Comparator<Pair<Double, Value>> comparator = new Comparator<Pair<Double, Value>>(){

                @Override
                public int compare(Pair<Double, Value> pair, Pair<Double, Value> pair2) {
                    return Double.compare(pair.getA(), pair2.getA());
                }
            };
            Collections.sort(arrayList, comparator);
            for (int i = 0; i < arrayList.size(); ++i) {
                listValue.list.set(i, (Value)((Pair)arrayList.get(i)).getB());
            }
        }));
        for (IFunction iFunction : IteratorFunctions.functions) {
            functions.add(iFunction);
        }
    }

    class ReverseListIterator
    implements Iterator<Value> {
        private ListIterator<Value> iter;

        public ReverseListIterator(ListValue listValue, ListIterator<Value> listIterator) {
            this.iter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasPrevious();
        }

        @Override
        public Value next() {
            return this.iter.previous();
        }
    }
}

