/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valuerep.MatrixRep;
import kickass.pass.valuerep.ValueRepresentation;
import kickass.pass.valuerep.VectorRep;
import kickass.pass.values.LockableValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.VectorValue;
import kickass.state.EvaluationState;

public class MatrixValue
extends LockableValue {
    public static MatrixValue invalid = new MatrixValue();
    private double[][] entries = new double[4][4];
    static FunctionTable functions = new StdFunctionTable(MatrixValue.getStandardFunctions());

    private MatrixValue() {
        this.setInvalid();
    }

    public MatrixValue(double[][] dArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.entries[i][j] = dArray[i][j];
            }
        }
    }

    @Override
    public String getType() {
        return "Matrix";
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        if (valueRepresentation == MatrixRep.representation) {
            return this.entries;
        }
        return null;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        if (this.isInvalid()) {
            return "<<Invalid StringMatrix>>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("[");
            for (int j = 0; j < 4; ++j) {
                if (j != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.entries[i][j]);
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    private Value matrixMatrixMul(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    double[] dArray4 = dArray3[j];
                    int n = i;
                    dArray4[n] = dArray4[n] + dArray[j][k] * dArray2[k][i];
                }
            }
        }
        return new MatrixValue(dArray3);
    }

    private Value matrixVectorMul(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray2[0] * dArray[0][0] + dArray2[1] * dArray[0][1] + dArray2[2] * dArray[0][2] + dArray[0][3], dArray2[0] * dArray[1][0] + dArray2[1] * dArray[1][1] + dArray2[2] * dArray[1][2] + dArray[1][3], dArray2[0] * dArray[2][0] + dArray2[1] * dArray[2][1] + dArray2[2] * dArray[2][2] + dArray[2][3], dArray2[0] * dArray[3][0] + dArray2[1] * dArray[3][1] + dArray2[2] * dArray[3][2] + dArray[3][3]};
        return new VectorValue(dArray3[0] / dArray3[3], dArray3[1] / dArray3[3], dArray3[2] / dArray3[3]);
    }

    private void outOfBoundCheck(int n, int n2, SourceRange sourceRange) throws AsmException {
        if (n < 0 || 4 <= n || n2 < 0 || 4 <= n2) {
            throw new AsmErrorException("Index out of bound (" + n + "," + n2 + ")", sourceRange);
        }
    }

    @Override
    public void lock(SourceRange sourceRange) {
        this.isLocked = true;
    }

    @Override
    public String toString() {
        return "MatrixValue";
    }

    static {
        functions.add(new MatrixFunction("get", 3, NumberValue.invalid, false){

            @Override
            protected Value f(MatrixValue matrixValue, SourceRange sourceRange, Value ... valueArray) {
                int n = valueArray[1].getInt(sourceRange);
                int n2 = valueArray[2].getInt(sourceRange);
                matrixValue.outOfBoundCheck(n, n2, sourceRange);
                return new NumberValue(matrixValue.entries[n][n2]);
            }
        });
        functions.add(new MatrixFunction("set", 4, null, true){

            @Override
            protected Value f(MatrixValue matrixValue, SourceRange sourceRange, Value ... valueArray) {
                matrixValue.ensureNotLocked(sourceRange);
                if (valueArray[1].isInvalid() || valueArray[2].isInvalid() || valueArray[3].isInvalid()) {
                    matrixValue.setInvalid();
                    return matrixValue;
                }
                int n = valueArray[1].getInt(sourceRange);
                int n2 = valueArray[2].getInt(sourceRange);
                double d = valueArray[3].getDouble(sourceRange);
                matrixValue.outOfBoundCheck(n, n2, sourceRange);
                matrixValue.entries[n][n2] = d;
                return matrixValue;
            }
        });
        functions.add(new MatrixFunction("*", 2, invalid, false){

            @Override
            protected Value f(MatrixValue matrixValue, SourceRange sourceRange, Value ... valueArray) {
                if (MatrixRep.hasMatrix(valueArray[1])) {
                    return matrixValue.matrixMatrixMul(matrixValue.entries, MatrixRep.getMatrix(valueArray[1], sourceRange));
                }
                if (VectorRep.hasVector(valueArray[1])) {
                    return matrixValue.matrixVectorMul(matrixValue.entries, VectorRep.getVector(valueArray[1], sourceRange));
                }
                throw new AsmErrorException("Can't multiply a matrix with an object of type " + valueArray[0].getType(), sourceRange);
            }
        });
    }

    static abstract class MatrixFunction
    extends Function {
        public MatrixFunction(String string, Integer n, Value value, boolean bl) {
            super(string, n, value, bl);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
            MatrixValue matrixValue = (MatrixValue)valueArray[0];
            if (matrixValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f(matrixValue, sourceRange, valueArray);
        }

        protected abstract Value f(MatrixValue var1, SourceRange var2, Value ... var3);
    }
}

