/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.Value;
import kickass.pass.values.misc.ToStringParams;
import kickass.state.EvaluationState;

public class NullValue
extends ImmutableValue {
    public static final NullValue instance = new NullValue();
    static FunctionTable functions = new StdFunctionTable(NullValue.getStandardFunctions());

    public static Value nullIfNull(Value value) {
        return value == null ? instance : value;
    }

    private NullValue() {
    }

    @Override
    public String getType() {
        return "Null";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public void getString(ToStringParams toStringParams) {
        toStringParams.sb().append("null");
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return BooleanValue.get(valueArray[0] == valueArray[1]);
            }
        });
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return BooleanValue.get(valueArray[0] != valueArray[1]);
            }
        });
    }
}

