/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.StringValue;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;

public class SegmentValue
extends ImmutableValue {
    public Segment segment;
    List<SegmentMemoryBlock> memBlocks;
    private Map<String, IValueHolder> variables = new HashMap<String, IValueHolder>();
    static FunctionTable functions = new StdFunctionTable(SegmentValue.getStandardFunctions());

    public SegmentValue(Segment segment, List<SegmentMemoryBlock> list) {
        this.segment = segment;
        this.memBlocks = list;
    }

    public Object getRepresentation(int n) {
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean hasInvalidContent() {
        return false;
    }

    @Override
    public String getType() {
        return "Segment";
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        if (string.equals("dest")) {
            return new ConstantValueHolder(new StringValue(this.segment.getDestination()), false);
        }
        if (string.equals("name")) {
            return new ConstantValueHolder(new StringValue(this.segment.getAbsoluteName()), false);
        }
        if (string.equals("virtual")) {
            return new ConstantValueHolder(BooleanValue.get(this.segment.isVirtual()));
        }
        return null;
    }

    public static Value flatten(List<SegmentMemoryBlock> list, String string) {
        MemblockValueCreator memblockValueCreator = new MemblockValueCreator();
        if (list.size() == 0) {
            memblockValueCreator.bytes = new byte[0];
            memblockValueCreator.start = 0L;
            memblockValueCreator.end = 0L;
            memblockValueCreator.name = string;
            memblockValueCreator.virtual = false;
            return memblockValueCreator.toValue();
        }
        int n = list.getFirst().getStart();
        int n2 = list.getLast().getEnd();
        byte[] byArray = new byte[Math.max(n2 - n, 0)];
        for (SegmentMemoryBlock segmentMemoryBlock : list) {
            if (segmentMemoryBlock.isVirtual()) continue;
            byte[] byArray2 = segmentMemoryBlock.getBytes();
            System.arraycopy(byArray2, 0, byArray, segmentMemoryBlock.getStart() - n, byArray2.length);
        }
        memblockValueCreator.bytes = byArray;
        memblockValueCreator.start = n;
        memblockValueCreator.virtual = false;
        memblockValueCreator.name = string;
        return memblockValueCreator.toValue();
    }

    private static ListValue toListValue(List<Value> list) {
        ListValue listValue = new ListValue(list.iterator());
        listValue.lock(null);
        return listValue;
    }

    static {
        functions.add(new Function("getBlocks", 1, ListValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                SegmentValue segmentValue = (SegmentValue)valueArray[0];
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (SegmentMemoryBlock segmentMemoryBlock : segmentValue.memBlocks) {
                    StructValue structValue = new MemblockValueCreator(segmentMemoryBlock).toValue();
                    arrayList.add(structValue);
                }
                return SegmentValue.toListValue(arrayList);
            }
        });
        functions.add(new Function("flattenBlocks", 1, ListValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                SegmentValue segmentValue = (SegmentValue)valueArray[0];
                return SegmentValue.flatten(segmentValue.memBlocks, "Flattened");
            }
        });
        functions.add(new Function("mergeConnectedBlocks", 1, ListValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                SegmentValue segmentValue = (SegmentValue)valueArray[0];
                ArrayList<Value> arrayList = new ArrayList<Value>();
                ArrayList<SegmentMemoryBlock> arrayList2 = new ArrayList<SegmentMemoryBlock>();
                for (SegmentMemoryBlock segmentMemoryBlock : segmentValue.memBlocks) {
                    boolean bl;
                    boolean bl2 = segmentMemoryBlock == segmentValue.memBlocks.getLast();
                    boolean bl3 = arrayList2.isEmpty();
                    boolean bl4 = bl = bl3 || ((SegmentMemoryBlock)arrayList2.getLast()).getEnd() >= segmentMemoryBlock.getStart();
                    if (!bl) {
                        arrayList.add(SegmentValue.flatten(arrayList2, "Connected"));
                        arrayList2.clear();
                    }
                    arrayList2.add(segmentMemoryBlock);
                    if (!bl2) continue;
                    arrayList.add(SegmentValue.flatten(arrayList2, "Connected"));
                }
                return SegmentValue.toListValue(arrayList);
            }
        });
    }

    static class MemblockValueCreator {
        String name;
        long start;
        long end;
        boolean virtual;
        byte[] bytes;

        public MemblockValueCreator() {
        }

        public MemblockValueCreator(SegmentMemoryBlock segmentMemoryBlock) {
            this.name = segmentMemoryBlock.getName();
            this.start = segmentMemoryBlock.getStart();
            this.end = segmentMemoryBlock.getEnd();
            this.virtual = segmentMemoryBlock.isVirtual();
            this.bytes = segmentMemoryBlock.getBytes();
        }

        public StructValue toValue() {
            ArrayList<NumberValue> arrayList = new ArrayList<NumberValue>();
            for (byte by : this.bytes) {
                arrayList.add(new NumberValue((double)by + 256.0));
            }
            List<String> list = Arrays.asList("name", "virtual", "start", "end", "bytes");
            Value[] valueArray = new Value[]{new StringValue(this.name), BooleanValue.get(this.virtual), new NumberValue(this.start), new NumberValue(this.start + (long)arrayList.size()), new ListValue(arrayList.iterator())};
            StructValue structValue = new StructValue("Memblock", list, valueArray);
            structValue.lock(null);
            return structValue;
        }
    }
}

