/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.exceptions.AsmException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.LockableValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.StringValue;
import kickass.pass.values.Value;
import kickass.pass.values.misc.ToStringParams;
import kickass.state.EvaluationState;

public class StructValue
extends LockableValue {
    private String structName;
    private List<String> variableNames;
    private Map<String, IValueHolder> variables = new HashMap<String, IValueHolder>();
    private Value noOfFields;
    static FunctionTable functions = new StdFunctionTable(StructValue.getStandardFunctions());
    private boolean checkingInvalidContent = false;

    public StructValue(String string, List<String> list, Value[] valueArray) {
        this.structName = string;
        this.variableNames = list;
        this.noOfFields = new NumberValue(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            NullValue nullValue = valueArray == null ? NullValue.instance : valueArray[i];
            VariableValueHolder variableValueHolder = new VariableValueHolder(nullValue);
            this.variables.put(string2, variableValueHolder);
        }
    }

    @Override
    public boolean hasInvalidContent() {
        if (this.checkingInvalidContent) {
            return false;
        }
        this.checkingInvalidContent = true;
        boolean bl = false;
        for (IValueHolder iValueHolder : this.variables.values()) {
            if (!iValueHolder.getWithoutSideeffect().isInvalidOrInvalidContent()) continue;
            bl = true;
            break;
        }
        this.checkingInvalidContent = false;
        return bl;
    }

    @Override
    public String getType() {
        return "struct";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public void getString(ToStringParams toStringParams) {
        StringBuilder stringBuilder = toStringParams.sb();
        if (this.isInvalid()) {
            stringBuilder.append("<<Invalid Struct>>");
            return;
        }
        stringBuilder.append("{#");
        stringBuilder.append(this.structName);
        stringBuilder.append(" ");
        if (toStringParams.visited().contains(this)) {
            stringBuilder.append("...)");
            return;
        }
        toStringParams.visited().add(this);
        ToStringParams toStringParams2 = toStringParams.withIsInsideContainer(true);
        boolean bl = true;
        for (Map.Entry<String, IValueHolder> entry : this.variables.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            entry.getValue().getWithoutSideeffect().getString(toStringParams2);
        }
        stringBuilder.append("}");
    }

    @Override
    public IValueHolder localGetVariable(String string, SourceRange sourceRange) throws AsmException {
        return this.variables.get(string);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (IValueHolder iValueHolder : this.variables.values()) {
            iValueHolder.getWithoutSideeffect().lock(sourceRange);
        }
    }

    static {
        functions.add(new StructValueFunction("getStructName", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, EvaluationState evaluationState, SourceRange sourceRange, Value ... valueArray) {
                return new StringValue(structValue.structName);
            }
        });
        functions.add(new StructValueFunction("get", 2, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, EvaluationState evaluationState, SourceRange sourceRange, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String string = this.getFieldName(valueArray[1], structValue, sourceRange);
                Value value = structValue.variables.get(string).get(evaluationState, sourceRange);
                return value;
            }
        });
        functions.add(new StructValueFunction("set", 3, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, EvaluationState evaluationState, SourceRange sourceRange, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String string = this.getFieldName(valueArray[1], structValue, sourceRange);
                Value value = valueArray[2];
                structValue.variables.get(string).set(value, evaluationState, sourceRange);
                return NullValue.instance;
            }
        });
        functions.add(new StructValueFunction("getFieldNames", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, EvaluationState evaluationState, SourceRange sourceRange, Value ... valueArray) {
                ListValue listValue = new ListValue(0);
                for (String string : structValue.variableNames) {
                    listValue.add(new StringValue(string));
                }
                return listValue;
            }
        });
        functions.add(new StructValueFunction("getNoOfFields", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, EvaluationState evaluationState, SourceRange sourceRange, Value ... valueArray) {
                return structValue.noOfFields;
            }
        });
        functions.add(new ValFunction2Arg<StructValue>("==", BooleanValue.invalid, (structValue, value, sourceRange) -> BooleanValue.get(structValue == value)));
        functions.add(new ValFunction2Arg<StructValue>("!=", BooleanValue.invalid, (structValue, value, sourceRange) -> BooleanValue.get(structValue != value)));
    }

    private static abstract class StructValueFunction
    extends Function {
        public StructValueFunction(String string, int n, Value value) {
            super(string, n, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
            StructValue structValue = (StructValue)valueArray[0];
            if (structValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f(structValue, evaluationState, sourceRange, valueArray);
        }

        protected abstract Value f(StructValue var1, EvaluationState var2, SourceRange var3, Value ... var4);

        String getFieldName(Value value, StructValue structValue, SourceRange sourceRange) {
            if (value.hasDouble()) {
                int n = value.getInt(sourceRange);
                if (n < 0 || structValue.variableNames.size() <= n) {
                    throw new AsmErrorException("Invalid name index: " + n, sourceRange);
                }
                return structValue.variableNames.get(n);
            }
            String string = value.getString(sourceRange);
            if (!structValue.variableNames.contains(string)) {
                throw new AsmErrorException("Unknown field name: " + string, sourceRange);
            }
            return string;
        }
    }
}

