/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values.interfaces;

import java.util.Arrays;
import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.util.functions.Func2;
import kickass.nonasm.util.functions.Func3;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.LambdaExpr;
import kickass.pass.values.Value;
import kickass.pass.values.interfaces.ICallable;
import kickass.state.EvaluationState;

public class CallableXArg
implements ICallable {
    private List<String> argNames;
    private Func2<EvaluationState, SourceRange, Value> func0arg = null;
    private Func3<Value, EvaluationState, SourceRange, Value> func1arg = null;
    private Func4<Value, Value, EvaluationState, SourceRange, Value> func2arg = null;

    public CallableXArg(List<String> list) {
        this.argNames = list;
    }

    public CallableXArg(String string, Func2<EvaluationState, SourceRange, Value> func2) {
        this.argNames = Arrays.asList(string);
        this.func0arg = func2;
    }

    public CallableXArg(String string, Func3<Value, EvaluationState, SourceRange, Value> func3) {
        this.argNames = Arrays.asList(string);
        this.func1arg = func3;
    }

    public CallableXArg(String string, String string2, Func4<Value, Value, EvaluationState, SourceRange, Value> func4) {
        this.argNames = Arrays.asList(string, string2);
        this.func2arg = func4;
    }

    @Override
    public boolean isCallable() {
        return true;
    }

    @Override
    public boolean isCallable(int n) {
        return n == this.argNames.size();
    }

    @Override
    public Value call(int n, Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        int n2 = valueArray.length - n;
        if (n2 == 0) {
            return this.call(evaluationState, sourceRange);
        }
        if (n2 == 1) {
            return this.call(valueArray[n + 0], evaluationState, sourceRange);
        }
        if (n2 == 2) {
            return this.call(valueArray[n + 0], valueArray[n + 1], evaluationState, sourceRange);
        }
        throw new AsmErrorException("Invalid number of arguments.", sourceRange);
    }

    @Override
    public Value call(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.call(0, valueArray, evaluationState, sourceRange);
    }

    @Override
    public Value call(EvaluationState evaluationState, SourceRange sourceRange) {
        return this.func0arg.apply(evaluationState, sourceRange);
    }

    @Override
    public Value call(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.func1arg.apply(value, evaluationState, sourceRange);
    }

    @Override
    public Value call(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        return this.func2arg.apply(value, value2, evaluationState, sourceRange);
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argNames;
    }

    @Override
    public Integer noOfCallArguments() {
        return this.getArgumentNames() == null ? null : Integer.valueOf(this.getArgumentNames().size());
    }

    @Override
    public LambdaExpr getLambdaExpr() {
        return null;
    }
}

