/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values.libs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.IFunction;
import kickass.pass.function.special.ValFunction1Arg;
import kickass.pass.function.special.ValFunction1ArgSta;
import kickass.pass.function.special.ValFunction2Arg;
import kickass.pass.function.special.ValFunction2ArgSta;
import kickass.pass.function.special.ValFunction3ArgSta;
import kickass.pass.function.special.ValFunction4ArgSta;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.HashtableValue;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.IteratorValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.interfaces.CallableXArg;
import kickass.pass.values.interfaces.ICallable;
import kickass.pass.values.libs.BoolHolder;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.pass.values.valueiterator.ValueIteratorDecorator;
import kickass.state.EvaluationState;

public class IteratorFunctions {
    public static List<IFunction> functions = new ArrayList<IFunction>();

    private static Value aggregate(Value value, Value value2, ICallable iCallable, Value value3, EvaluationState evaluationState, SourceRange sourceRange) {
        Value value4;
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (value2 != null) {
            value4 = value2;
        } else {
            if (!iValueIterator.hasNext()) {
                return NullValue.instance;
            }
            value4 = iValueIterator.next(sourceRange);
        }
        while (iValueIterator.hasNext()) {
            value4 = iCallable.call(value4, iValueIterator.next(sourceRange), evaluationState, sourceRange);
        }
        return value3 == null ? value4 : value3.call(value4, evaluationState, sourceRange);
    }

    private static Value aggregateWithSelect(Value value, ICallable iCallable, ICallable iCallable2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        boolean bl = true;
        Value value2 = null;
        while (iValueIterator.hasNext()) {
            Value value3 = iValueIterator.next(sourceRange);
            if (value3.isInvalid()) {
                return NumberValue.invalid;
            }
            if (iCallable != null && (value3 = iCallable.call(value3, evaluationState, sourceRange)).isInvalid()) {
                return NumberValue.invalid;
            }
            if (bl) {
                value2 = value3;
                bl = false;
            } else {
                value2 = iCallable2.call(value2, value3, evaluationState, sourceRange);
            }
            if (!value2.isInvalid()) continue;
            return NumberValue.invalid;
        }
        return value2;
    }

    private static Value all(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        while (iValueIterator.hasNext()) {
            if (value2.call(iValueIterator.next(sourceRange), evaluationState, sourceRange).getBoolean(sourceRange)) continue;
            return BooleanValue.falseValue;
        }
        return BooleanValue.trueValue;
    }

    private static Value any(Value value, SourceRange sourceRange) {
        return BooleanValue.get(value.getIterator(sourceRange).hasNext());
    }

    private static Value any(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        while (iValueIterator.hasNext()) {
            if (!value2.call(iValueIterator.next(sourceRange), evaluationState, sourceRange).getBoolean(sourceRange)) continue;
            return BooleanValue.trueValue;
        }
        return BooleanValue.falseValue;
    }

    static Value count(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        int n = 0;
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        while (iValueIterator.hasNext()) {
            iValueIterator.next(sourceRange);
            ++n;
        }
        return new NumberValue(n);
    }

    static Value count(Value value, ICallable iCallable, EvaluationState evaluationState, SourceRange sourceRange) {
        int n = 0;
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        while (iValueIterator.hasNext()) {
            Value value2 = iValueIterator.next(sourceRange);
            if (!iCallable.call(value2, evaluationState, sourceRange).getBoolean(sourceRange)) continue;
            ++n;
        }
        return new NumberValue(n);
    }

    static Value skip(Value value, int n, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        for (int i = 0; i < n && iValueIterator.hasNext(); ++i) {
            iValueIterator.next(sourceRange);
        }
        return value;
    }

    private static Value groupBy(Value value, Value value2, Value value3, EvaluationState evaluationState, SourceRange sourceRange) {
        Object object;
        Value value4;
        if (!value2.isCallable()) {
            throw new AsmErrorException("Key argument must be callable.", sourceRange);
        }
        int n = value2.noOfCallArguments();
        Value[] valueArray = new Value[n];
        if (value3 != null && !value3.isCallable()) {
            throw new AsmErrorException("Value argument must be callable.", sourceRange);
        }
        Value[] valueArray2 = value3 == null ? null : new Value[value3.noOfCallArguments().intValue()];
        int n2 = 0;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        while (iValueIterator.hasNext()) {
            ArrayList<Object> arrayList;
            value4 = null;
            Object object2 = iValueIterator.next(sourceRange);
            if (n == 1) {
                valueArray[0] = object2;
            } else {
                valueArray[0] = value4 = new NumberValue(n2);
                valueArray[1] = object2;
            }
            Value object3 = value2.call(valueArray, evaluationState, sourceRange);
            if (object3.isInvalid()) {
                return HashtableValue.invalid;
            }
            if (value3 != null) {
                if (valueArray2.length == 1) {
                    valueArray2[0] = object2;
                } else {
                    valueArray2[0] = value4 != null ? value4 : new NumberValue(n2);
                    valueArray2[1] = object2;
                }
                object2 = value3.call(valueArray2, evaluationState, sourceRange);
            }
            if ((arrayList = (ArrayList<Object>)hashMap.get(object = object3.getString(sourceRange))) == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(object, arrayList);
            }
            arrayList.add(object2);
            ++n2;
        }
        value4 = new HashtableValue();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = new ListValue(((ArrayList)entry.getValue()).iterator());
            ((HashtableValue)value4).putValue((String)entry.getKey(), (Value)object);
        }
        return value4;
    }

    private static Value sequenceEqual(Value value, Value value2, Value value3, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        IValueIterator iValueIterator2 = value2.getIterator(sourceRange);
        while (iValueIterator.hasNext() && iValueIterator2.hasNext()) {
            Value value4;
            Value value5 = iValueIterator.next(sourceRange);
            if (value3.call(value5, value4 = iValueIterator2.next(sourceRange), evaluationState, sourceRange).getBoolean(sourceRange)) continue;
            return BooleanValue.falseValue;
        }
        return BooleanValue.get(iValueIterator.hasNext() == iValueIterator2.hasNext());
    }

    private static Value select(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (!value2.isCallable(1)) {
            throw new AsmErrorException("select argument must be callable with one argument", sourceRange);
        }
        return new IteratorValue(new ValueIteratorDecorator(iValueIterator, sourceRange, () -> {
            if (!iValueIterator.hasNext()) {
                return null;
            }
            return value2.call(iValueIterator.next(sourceRange), evaluationState, sourceRange);
        }));
    }

    private static Value skipWhile(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (!value2.isCallable(1)) {
            throw new AsmErrorException("The argument must be callable with one argument", sourceRange);
        }
        BoolHolder boolHolder = new BoolHolder();
        return new IteratorValue(new ValueIteratorDecorator(iValueIterator, sourceRange, () -> {
            while (iValueIterator.hasNext()) {
                Value value2 = iValueIterator.next(sourceRange);
                if (!boolHolder.b) {
                    if (value2.call(value2, evaluationState, sourceRange).getBoolean(sourceRange)) continue;
                    boolHolder.b = true;
                }
                return value2;
            }
            return null;
        }));
    }

    private static Value takeWhile(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (!value2.isCallable(1)) {
            throw new AsmErrorException("The argument must be callable with one argument", sourceRange);
        }
        BoolHolder boolHolder = new BoolHolder();
        return new IteratorValue(new ValueIteratorDecorator(iValueIterator, sourceRange, () -> {
            block1: {
                if (boolHolder.b) break block1;
                Value value2 = iValueIterator.next(sourceRange);
                if (value2.call(value2, evaluationState, sourceRange).getBoolean(sourceRange)) {
                    return value2;
                }
                boolHolder.b = true;
            }
            return null;
        }));
    }

    private static Value where(Value value, Value value2, EvaluationState evaluationState, SourceRange sourceRange) {
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (!value2.isCallable(1)) {
            throw new AsmErrorException("The argument must be callable with one argument", sourceRange);
        }
        return new IteratorValue(new ValueIteratorDecorator(iValueIterator, sourceRange, () -> {
            while (iValueIterator.hasNext()) {
                Value value2 = iValueIterator.next(sourceRange);
                if (!value2.call(value2, evaluationState, sourceRange).getBoolean(sourceRange)) continue;
                return value2;
            }
            return null;
        }));
    }

    static {
        CallableXArg callableXArg = new CallableXArg("a", "b", (value, value2, evaluationState, sourceRange) -> value.getDouble((SourceRange)sourceRange) < value2.getDouble((SourceRange)sourceRange) ? value : value2);
        CallableXArg callableXArg2 = new CallableXArg("a", "b", (value, value2, evaluationState, sourceRange) -> value.getDouble((SourceRange)sourceRange) > value2.getDouble((SourceRange)sourceRange) ? value : value2);
        CallableXArg callableXArg3 = new CallableXArg("a", "b", (value, value2, evaluationState, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange) + value2.getDouble((SourceRange)sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("aggregate", InvalidValue.instance, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.aggregate(value, null, value2, null, evaluationState, sourceRange)));
        functions.add(new ValFunction3ArgSta<Value>("aggregate", InvalidValue.instance, (value, value2, value3, evaluationState, sourceRange) -> IteratorFunctions.aggregate(value, value2, value3, null, evaluationState, sourceRange)));
        functions.add(new ValFunction4ArgSta<Value>("aggregate", InvalidValue.instance, (value, value2, value3, value4, evaluationState, sourceRange) -> IteratorFunctions.aggregate(value, value2, value3, value4, evaluationState, sourceRange)));
        functions.add(new ValFunction1ArgSta<Value>("sum", NumberValue.invalid, (value, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, null, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("sum", NumberValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, value2, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction1ArgSta<Value>("min", NumberValue.invalid, (value, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, null, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("min", NumberValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, value2, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction1ArgSta<Value>("max", NumberValue.invalid, (value, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, null, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("max", NumberValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.aggregateWithSelect(value, value2, callableXArg3, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("all", BooleanValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.all(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction1Arg<Value>("any", BooleanValue.invalid, (value, sourceRange) -> IteratorFunctions.any(value, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("any", BooleanValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.any(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction1ArgSta<Value>("count", NumberValue.invalid, (value, evaluationState, sourceRange) -> IteratorFunctions.count(value, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("count", NumberValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.count(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("groupBy", HashtableValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.groupBy(value, value2, null, evaluationState, sourceRange)));
        functions.add(new ValFunction3ArgSta<Value>("groupBy", HashtableValue.invalid, (value, value2, value3, evaluationState, sourceRange) -> IteratorFunctions.groupBy(value, value2, value3, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("select", IteratorValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.select(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction3ArgSta<Value>("sequenceEqual", BooleanValue.invalid, (value, value2, value3, evaluationState, sourceRange) -> IteratorFunctions.sequenceEqual(value, value2, value3, evaluationState, sourceRange)));
        functions.add(new ValFunction2Arg<Value>("skip", IteratorValue.invalid, (value, value2, sourceRange) -> IteratorFunctions.skip(value, value2.getInt((SourceRange)sourceRange), sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("skipWhile", IteratorValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.skipWhile(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("takeWhile", IteratorValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.takeWhile(value, value2, evaluationState, sourceRange)));
        functions.add(new ValFunction1Arg<Value>("toList", ListValue.invalid, (value, sourceRange) -> new ListValue(value.getIterator((SourceRange)sourceRange), (SourceRange)sourceRange)));
        functions.add(new ValFunction2ArgSta<Value>("where", IteratorValue.invalid, (value, value2, evaluationState, sourceRange) -> IteratorFunctions.where(value, value2, evaluationState, sourceRange)));
    }
}

