/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values.valueiterator;

import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.IValueIterator;

public class ChainValueIterator
implements IValueIterator {
    private int idx = 0;
    private List<IValueIterator> chain;

    public ChainValueIterator(List<IValueIterator> list) {
        this.chain = list;
    }

    @Override
    public boolean hasNext() {
        this.skipEmptyIters();
        if (this.idx >= this.chain.size()) {
            return false;
        }
        return this.chain.get(this.idx).hasNext();
    }

    @Override
    public Value next(SourceRange sourceRange) {
        this.skipEmptyIters();
        Value value = this.chain.get(this.idx).next(sourceRange);
        return value;
    }

    private void skipEmptyIters() {
        if (this.idx < this.chain.size() && !this.chain.get(this.idx).hasNext()) {
            ++this.idx;
        }
    }

    @Override
    public boolean hasInvalidContent() {
        for (IValueIterator iValueIterator : this.chain) {
            if (!iValueIterator.hasInvalidContent()) continue;
            return true;
        }
        return false;
    }
}

