/*
 * Decompiled with CFR 0.152.
 */
package kickass.setup.configuration.optionparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import kickass.common.exceptions.AsmErrorException;
import kickass.setup.configuration.optionparser.KickAssemblerConfigFileUtil;
import kickass.state.EvaluationState;

public class KickAssemblerPluginConfigParser {
    public static void parsePluginFile(String string, EvaluationState evaluationState) {
        File file = KickAssemblerConfigFileUtil.openConfigFile(string);
        if (file == null) {
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("//")) continue;
                Object object = KickAssemblerPluginConfigParser.createObjectOrNull(string2);
                if (object == null) {
                    evaluationState.log.println("Error while parsing " + string + ". Coundn't find class or create object for pluging: " + string2);
                    continue;
                }
                evaluationState.pluginMgr.registerPlugin(object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new AsmErrorException("Error while reading config file (" + string + "): " + iOException.getMessage());
        }
    }

    private static Object createObjectOrNull(String string) {
        try {
            return Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

