/*
 * Decompiled with CFR 0.152.
 */
package kickass.setup.configuration.parameters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.nonasm.tools.FileUtil;
import kickass.setup.configuration.parameters.KickAssemblerParameters;

public class KickAssemblerParametersParser {
    private Logger log;

    public KickAssemblerParametersParser(Logger logger) {
        this.log = logger;
    }

    public void parseArgs(String[] stringArray, KickAssemblerParameters kickAssemblerParameters) {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).equalsIgnoreCase("-cfgfile")) {
                this.ensureArgument(n, stringArray, "-configfile");
                kickAssemblerParameters.extraCfgFilenames.add(stringArray[n++]);
                continue;
            }
            if (string.equalsIgnoreCase("-o")) {
                this.ensureArgument(n, stringArray, "-o");
                kickAssemblerParameters.outputfile = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-odir")) {
                this.ensureArgument(n, stringArray, "-odir");
                kickAssemblerParameters.outputDir = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-libdir")) {
                this.ensureArgument(n, stringArray, "-libdir");
                kickAssemblerParameters.libPath.add(new File(stringArray[n++]));
                continue;
            }
            if (string.equalsIgnoreCase("-replacefile")) {
                this.ensureTwoArguments(n, stringArray, "-replacefile");
                String string2 = this.getCanonicalPath(stringArray[n++]);
                kickAssemblerParameters.fileReplacementMap.put(string2, new File(stringArray[n++]));
                continue;
            }
            if (string.equalsIgnoreCase("-execute")) {
                this.ensureArgument(n, stringArray, "-execute");
                kickAssemblerParameters.executeOnSuccess = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-executenoarg")) {
                this.ensureArgument(n, stringArray, "-executenoarg");
                kickAssemblerParameters.executeOnSuccessNoArg = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-executelog")) {
                this.ensureArgument(n, stringArray, "-executelog");
                kickAssemblerParameters.executeLog = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-showmem")) {
                kickAssemblerParameters.showMemoryMap = true;
                continue;
            }
            if (string.equalsIgnoreCase("-debug")) {
                kickAssemblerParameters.debug = true;
                continue;
            }
            if (string.equalsIgnoreCase("-binfile")) {
                kickAssemblerParameters.binFile = true;
                continue;
            }
            if (string.equalsIgnoreCase("-dtv")) {
                kickAssemblerParameters.dtvMode = true;
                continue;
            }
            if (string.equalsIgnoreCase("-mbfiles")) {
                kickAssemblerParameters.filesForEachMemBlock = true;
                continue;
            }
            if (string.equalsIgnoreCase("-time")) {
                kickAssemblerParameters.time = true;
                continue;
            }
            if (string.equalsIgnoreCase("-warningsoff")) {
                kickAssemblerParameters.warnings = false;
                continue;
            }
            if (string.equalsIgnoreCase("-excludeillegal")) {
                kickAssemblerParameters.includeIllegalOpcodes = false;
                continue;
            }
            if (string.equalsIgnoreCase("-fillbyte")) {
                this.ensureArgument(n, stringArray, "-fillbyte");
                try {
                    kickAssemblerParameters.fillByte = (byte)Integer.valueOf(stringArray[n++]).intValue();
                }
                catch (Exception exception) {
                    this.log.println("Invalid arg for -fillbyte: " + stringArray[n - 1]);
                }
                continue;
            }
            if (string.equalsIgnoreCase("-asminfo")) {
                this.ensureArgument(n, stringArray, "-asminfo");
                try {
                    kickAssemblerParameters.assembleInfos.parseAndAdd(stringArray[n++]);
                }
                catch (Exception exception) {
                    this.log.println(exception.getMessage());
                }
                continue;
            }
            if (string.equalsIgnoreCase("-asminfofile")) {
                this.ensureArgument(n, stringArray, "-asminfofile");
                kickAssemblerParameters.assembleInfoFilename = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-asminfotostdout")) {
                kickAssemblerParameters.assembleInfoToStdOut = true;
                continue;
            }
            if (string.equalsIgnoreCase("-noeval")) {
                kickAssemblerParameters.noEval = true;
                continue;
            }
            if (string.equalsIgnoreCase("-nooutput")) {
                kickAssemblerParameters.noOutput = true;
                continue;
            }
            if (string.equalsIgnoreCase("-maxaddr")) {
                this.ensureArgument(n, stringArray, "-maxaddr");
                try {
                    kickAssemblerParameters.maxMemoryAddress = Integer.valueOf(stringArray[n++]);
                }
                catch (Exception exception) {
                    this.log.println("Invalid arg for -maxaddr: " + stringArray[n - 1]);
                }
                continue;
            }
            if (string.equalsIgnoreCase("-aom")) {
                kickAssemblerParameters.allowOverlappingMemoryblocks = true;
                continue;
            }
            if (string.equalsIgnoreCase("-vicesymbols")) {
                kickAssemblerParameters.viceSymbols = true;
                continue;
            }
            if (string.equalsIgnoreCase("-silentmode")) {
                kickAssemblerParameters.silentMode = true;
                continue;
            }
            if (string.equalsIgnoreCase("-bytedump")) {
                kickAssemblerParameters.byteDump = true;
                continue;
            }
            if (string.equalsIgnoreCase("-debugdump")) {
                kickAssemblerParameters.debugDump = true;
                continue;
            }
            if (string.equalsIgnoreCase("-bytedumpfile")) {
                this.ensureArgument(n, stringArray, "-bytedumpfile");
                kickAssemblerParameters.byteDumpFile = stringArray[n++];
                kickAssemblerParameters.byteDump = true;
                continue;
            }
            if (string.equalsIgnoreCase("-symbolfile")) {
                kickAssemblerParameters.symbolFile = true;
                continue;
            }
            if (string.equalsIgnoreCase("-symbolfiledir")) {
                this.ensureArgument(n, stringArray, "-symbolfiledir");
                kickAssemblerParameters.symbolFileOutputDir = stringArray[n++];
                continue;
            }
            if (string.equalsIgnoreCase("-afo")) {
                kickAssemblerParameters.allowFileOutput = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pseudoc3x")) {
                kickAssemblerParameters.pseudoc3x = true;
                continue;
            }
            if (string.equalsIgnoreCase("-displaylibraries")) {
                kickAssemblerParameters.displayLibraries = true;
                continue;
            }
            if (string.equalsIgnoreCase("-log")) {
                this.ensureArgument(n, stringArray, "-log");
                try {
                    this.log.addPrintStream(new PrintStream(new FileOutputStream(stringArray[n++])));
                }
                catch (Exception exception) {
                    this.log.println("Couldn't create log : " + exception.getMessage());
                }
                continue;
            }
            if (string.equalsIgnoreCase("-define")) {
                this.ensureArgument(n, stringArray, "-define");
                kickAssemblerParameters.defines.add(stringArray[n++]);
                continue;
            }
            if (string.charAt(0) == ':') {
                this.parseCommandLineVar(string, kickAssemblerParameters.cmdLineArguments);
                continue;
            }
            if (kickAssemblerParameters.inputFileName == null) {
                kickAssemblerParameters.inputFileName = string;
                continue;
            }
            this.log.println("Warning. Already have an inputfile. Won't use '" + string + "'");
        }
    }

    private void ensureArgument(int n, String[] stringArray, String string) {
        if (n >= stringArray.length) {
            this.log.println("Missing parameter for '" + string + "' option");
            System.exit(1);
        }
    }

    private void ensureTwoArguments(int n, String[] stringArray, String string) {
        if (n + 1 >= stringArray.length) {
            this.log.println("Missing parameter for '" + string + "' option");
            System.exit(1);
        }
    }

    private String getCanonicalPath(String string) {
        try {
            return FileUtil.getCanonicalPath(new File(string));
        }
        catch (Exception exception) {
            this.log.println("Cannot get canonincal file path for '" + string + "'");
            System.exit(1);
            return "";
        }
    }

    private void parseCommandLineVar(String string, Map<String, String> map) {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new AsmErrorException("Can't parse user command line argument. Missing '='. " + string, null);
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        if (string2.length() == 0) {
            throw new AsmErrorException("Can't parse user command line argument. Invalid argument name. " + string, null);
        }
        if (string3.length() != 0 && string3.charAt(0) == '\"') {
            if (string3.charAt(string3.length() - 1) == '\"') {
                throw new AsmErrorException("Unterminated '\"' in command line argument. " + string, null);
            }
            string3 = string3.substring(1, string3.length() - 2);
        }
        map.put(string2, string3);
    }
}

