/*
 * Decompiled with CFR 0.152.
 */
package kickass.state;

import java.util.HashMap;
import kickass.common.diagnostics.DiagnosticManager;
import kickass.common.log.Logger;
import kickass.common.outputmanager.IOutputManager;
import kickass.common.syntaxinfo.SyntaxInfoManager;
import kickass.parsing.mainparse.MainParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.preprocessor.PreprocessorManager;
import kickass.pass.sideeffect.SideeffectManager;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.state.AssertManager;
import kickass.state.CallStack;
import kickass.state.FileManager;
import kickass.state.PluginManager;
import kickass.state.breakpoint.BreakpointManager;
import kickass.state.c64output.C64OutputManager;
import kickass.state.libraries.MathLibrary;
import kickass.state.namespace.AnySegmentModifier;
import kickass.state.namespace.NamespaceManager;
import kickass.state.scope.ScopeManager;
import kickass.state.segments.SegmentManager;

public class EvaluationState {
    private final long initSeed = (long)(Math.random() * 1.0E7);
    public final KickAssemblerParameters parameters = new KickAssemblerParameters();
    public MainParser mainParser;
    public final Logger log = new Logger(true);
    public final PreprocessorManager preprocessorMgr = new PreprocessorManager(this);
    public final PluginManager pluginMgr = new PluginManager(this);
    public final NamespaceManager namespaceMgr = new NamespaceManager(this);
    public final ScopeManager scopeMgr = new ScopeManager(this.namespaceMgr.getRootNamespace().getScope());
    public final SegmentManager segmentMgr = new SegmentManager(this);
    public final AssertManager assertMgr = new AssertManager();
    public final SyntaxInfoManager syntaxInfoMgr = new SyntaxInfoManager();
    public final DiagnosticManager diagnosticMgr = new DiagnosticManager();
    public final FileManager fileMgr = new FileManager();
    public final SideeffectManager sideeffectMgr = new SideeffectManager();
    public IOutputManager outputMgr;
    public final CallStack callStack = new CallStack();
    public final C64OutputManager c64OutputMgr = new C64OutputManager(this);
    public final BreakpointManager breakpointMgr = new BreakpointManager();
    public final HashMap<ParameterMap, AnySegmentModifier> resolvedSegmentModifiers = new HashMap();
    private int passNo = -1;
    private boolean failOnInvalidValue;
    private boolean madeMetaProgress;
    private boolean zeropageFlag = false;

    public void prepareNewPass() {
        ++this.passNo;
        this.madeMetaProgress = false;
        MathLibrary.setSeed(this.initSeed);
        this.namespaceMgr.setCurrentNamespace(this.namespaceMgr.getRootNamespace());
        this.scopeMgr.setCurrentScope(this.namespaceMgr.getRootNamespace().getScope());
        this.segmentMgr.initPass();
    }

    public int getPassNo() {
        return this.passNo;
    }

    public boolean failOnInvalidValue() {
        return this.failOnInvalidValue;
    }

    public void setFailOnInvalidValue(boolean bl) {
        this.failOnInvalidValue = bl;
    }

    public void setMadeMetaProgress() {
        this.madeMetaProgress = true;
    }

    public boolean getMadeMetaProgress() {
        return this.madeMetaProgress;
    }

    public boolean getZeropageFlag() {
        return this.zeropageFlag;
    }

    public void setZeropageFlag(boolean bl) {
        this.zeropageFlag = bl;
    }

    public boolean replaceZeropageFlag(boolean bl) {
        boolean bl2 = this.zeropageFlag;
        this.zeropageFlag = bl;
        return bl2;
    }
}

