/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.libraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.function.special.Function2ArgSta;
import kickass.pass.function.special.Function3Arg;
import kickass.pass.function.special.Function3ArgSta;
import kickass.pass.function.special.FunctionVarArg;
import kickass.pass.function.special.FunctionVarArgSta;
import kickass.pass.values.InvalidValue;
import kickass.pass.values.IteratorValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.StructValue;
import kickass.pass.values.Value;
import kickass.pass.values.valueiterator.ChainValueIterator;
import kickass.pass.values.valueiterator.IValueIterator;
import kickass.pass.values.valueiterator.IterationTool;
import kickass.pass.values.valueiterator.StdValueIterator;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;

public class IteratorLibrary
implements ILibrary {
    @Override
    public String getName() {
        return "Iterator";
    }

    public List<LibConstant> getConstants() {
        ArrayList<LibConstant> arrayList = new ArrayList<LibConstant>();
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function1Arg("range", IteratorValue.invalid, (value, sourceRange) -> IteratorLibrary.range(0.0, value.getDouble((SourceRange)sourceRange), 1.0)));
        arrayList.add(new Function2Arg("range", IteratorValue.invalid, (value, value2, sourceRange) -> IteratorLibrary.range(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange), 1.0)));
        arrayList.add(new Function3Arg("range", IteratorValue.invalid, (value, value2, value3, sourceRange) -> IteratorLibrary.range(value.getDouble((SourceRange)sourceRange), value2.getDouble((SourceRange)sourceRange), value3.getDouble((SourceRange)sourceRange))));
        arrayList.add(new Function1Arg("spriteRange", IteratorValue.invalid, (value, sourceRange) -> IteratorLibrary.spriteRange(value.getInt((SourceRange)sourceRange), Integer.MAX_VALUE)));
        arrayList.add(new Function2Arg("spriteRange", IteratorValue.invalid, (value, value2, sourceRange) -> IteratorLibrary.spriteRange(value.getInt((SourceRange)sourceRange), value2.getInt((SourceRange)sourceRange))));
        arrayList.add(new Function2ArgSta("reduce", InvalidValue.instance, (value, value2, evaluationState, sourceRange) -> IteratorLibrary.reduce(value, value2, null, evaluationState, sourceRange)));
        arrayList.add(new Function3ArgSta("reduce", InvalidValue.instance, (value, value2, value3, evaluationState, sourceRange) -> IteratorLibrary.reduce(value, value2, value3, evaluationState, sourceRange)));
        arrayList.add(new FunctionVarArgSta("map", IteratorValue.invalid, (valueArray, evaluationState, sourceRange) -> IteratorLibrary.map(valueArray, evaluationState, sourceRange)));
        arrayList.add(new FunctionVarArg("chain", (valueArray, sourceRange) -> IteratorLibrary.chain(valueArray, sourceRange)));
        arrayList.add(new FunctionVarArg("flatten", (valueArray, sourceRange) -> IteratorLibrary.flatten(valueArray, sourceRange)));
        return arrayList;
    }

    private static Value range(final double d, final double d2, final double d3) {
        Iterator<Value> iterator = new Iterator<Value>(){
            double current;
            {
                this.current = d;
            }

            @Override
            public boolean hasNext() {
                if (d3 == 0.0) {
                    return false;
                }
                return d3 > 0.0 ? this.current < d2 : this.current > d2;
            }

            @Override
            public Value next() {
                if (!this.hasNext()) {
                    return NullValue.instance;
                }
                NumberValue numberValue = new NumberValue(this.current);
                this.current += d3;
                return numberValue;
            }
        };
        return new IteratorValue(new StdValueIterator(iterator));
    }

    private static Value reduce(Value value, Value value2, Value value3, EvaluationState evaluationState, SourceRange sourceRange) {
        Value value4;
        IValueIterator iValueIterator = value.getIterator(sourceRange);
        if (value3 != null) {
            value4 = value3;
        } else {
            if (!iValueIterator.hasNext()) {
                return NullValue.instance;
            }
            value4 = iValueIterator.next(sourceRange);
        }
        while (iValueIterator.hasNext()) {
            value4 = value2.call(value4, iValueIterator.next(sourceRange), evaluationState, sourceRange);
        }
        return value4;
    }

    private static Value map(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        boolean bl;
        int n;
        if (valueArray.length < 2) {
            throw new AsmErrorException("Missing arguments. The format is map(lambda, iter, iter, ...)", sourceRange);
        }
        Value value = valueArray[0];
        int n2 = value.noOfCallArguments();
        int n3 = valueArray.length - 1;
        IValueIterator[] iValueIteratorArray = new IValueIterator[n3];
        for (n = 0; n < n3; ++n) {
            iValueIteratorArray[n] = valueArray[n + 1].getIterator(sourceRange);
        }
        n = n3 == n2 - 1 ? 1 : 0;
        boolean bl2 = bl = n3 == n2;
        if (!bl && n == 0) {
            throw new AsmErrorException("The number of iterators doesn't match the number of arguments in the lambda.", sourceRange);
        }
        Value[] valueArray2 = new Value[n2];
        return IterationTool.createIteratorValue(n != 0, iValueIteratorArray, 0, valueArray2, sourceRange, () -> value.call(valueArray2, evaluationState, sourceRange));
    }

    private static Value spriteRange(final int n, final int n2) {
        final List<String> list = Arrays.asList("byteNo", "no", "spriteNo", "sNo", "spriteByteX", "sBX", "spritePixelX", "sPX", "spritePixelY", "sPY", "row", "column", "col", "byteX", "bX", "pixelX", "pX", "pixelY", "pY");
        Iterator<Value> iterator = new Iterator<Value>(){
            int byteNo = 0;

            @Override
            public boolean hasNext() {
                return this.byteNo < n * 64;
            }

            @Override
            public Value next() {
                if (!this.hasNext()) {
                    return NullValue.instance;
                }
                int n11 = (int)Math.floor(this.byteNo / 64);
                int n22 = this.byteNo & 0x3F;
                int n3 = n22 == 63 ? 0 : n22 % 3;
                int n4 = n22 == 63 ? 0 : n22 % 3 * 8;
                int n5 = n22 == 63 ? 0 : n22 / 3;
                int n6 = n11 / n2;
                int n7 = n11 % n2;
                int n8 = n22 == 63 ? 0 : n3 + n7 * 3;
                int n9 = n22 == 63 ? 0 : n4 + n7 * 8 * 3;
                int n10 = n22 == 63 ? 0 : n5 + n6 * 21;
                NumberValue numberValue = new NumberValue(this.byteNo);
                NumberValue numberValue2 = new NumberValue(n11);
                NumberValue numberValue3 = new NumberValue(n3);
                NumberValue numberValue4 = new NumberValue(n4);
                NumberValue numberValue5 = new NumberValue(n5);
                NumberValue numberValue6 = new NumberValue(n6);
                NumberValue numberValue7 = new NumberValue(n7);
                NumberValue numberValue8 = new NumberValue(n8);
                NumberValue numberValue9 = new NumberValue(n9);
                NumberValue numberValue10 = new NumberValue(n10);
                StructValue structValue = new StructValue("SpriterangeInfo", list, new Value[]{numberValue, numberValue, numberValue2, numberValue2, numberValue3, numberValue3, numberValue4, numberValue4, numberValue5, numberValue5, numberValue6, numberValue7, numberValue7, numberValue8, numberValue8, numberValue9, numberValue9, numberValue10, numberValue10});
                ++this.byteNo;
                return structValue;
            }
        };
        return new IteratorValue(new StdValueIterator(iterator));
    }

    private static Value chain(Value[] valueArray, SourceRange sourceRange) {
        ArrayList<IValueIterator> arrayList = new ArrayList<IValueIterator>();
        for (Value value : valueArray) {
            if (value.isInvalid()) {
                return IteratorValue.invalid;
            }
            if (value.hasIterator()) {
                arrayList.add(value.getIterator(sourceRange));
                continue;
            }
            StdValueIterator stdValueIterator = new StdValueIterator(Collections.singleton(value).iterator());
            arrayList.add(stdValueIterator);
        }
        return new IteratorValue(new ChainValueIterator(arrayList));
    }

    private static Value flatten(Value[] valueArray, SourceRange sourceRange) {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (Value value : valueArray) {
            if (value.isInvalid()) {
                return IteratorValue.invalid;
            }
            boolean bl = value.hasIterator();
            if (!bl) {
                arrayList.add(value);
                continue;
            }
            IValueIterator iValueIterator = value.getIterator(sourceRange);
            while (iValueIterator.hasNext()) {
                arrayList.add(iValueIterator.next(sourceRange));
            }
        }
        return IteratorLibrary.chain(arrayList.toArray(new Value[arrayList.size()]), sourceRange);
    }
}

