/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kickass._65xx._65xxArgType;
import kickass._65xx._65xxArgTypeUtil;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.special.Function0Arg;
import kickass.pass.function.special.Function1Arg;
import kickass.pass.function.special.Function2Arg;
import kickass.pass.values.HashtableValue;
import kickass.pass.values.ListValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.OutputFileValue;
import kickass.pass.values.Value;
import kickass.pass.values._65xxArgumentValue;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;

public class StdConstructorLibrary
implements ILibrary {
    @Override
    public String getName() {
        return "Constructors";
    }

    public List<LibConstant> getConstants() {
        ArrayList<LibConstant> arrayList = new ArrayList<LibConstant>();
        arrayList.add(new LibConstant("AT_ABSOLUTE", new NumberValue(_65xxArgType.unresolvedAbsolute.getIdNo())));
        arrayList.add(new LibConstant("AT_ZEROPAGE", new NumberValue(_65xxArgType.zeropage.getIdNo())));
        arrayList.add(new LibConstant("AT_ABSOLUTEX", new NumberValue(_65xxArgType.unresolvedAbsoluteX.getIdNo())));
        arrayList.add(new LibConstant("AT_ABSOLUTEY", new NumberValue(_65xxArgType.unresolvedAbsoluteY.getIdNo())));
        arrayList.add(new LibConstant("AT_IMMEDIATE", new NumberValue(_65xxArgType.immediate.getIdNo())));
        arrayList.add(new LibConstant("AT_INDIRECT", new NumberValue(_65xxArgType.unresolvedIndirect.getIdNo())));
        arrayList.add(new LibConstant("AT_IZEROPAGEX", new NumberValue(_65xxArgType.indirectZeropageX.getIdNo())));
        arrayList.add(new LibConstant("AT_IZEROPAGEY", new NumberValue(_65xxArgType.indirectZeropageY.getIdNo())));
        arrayList.add(new LibConstant("AT_NONE", new NumberValue(_65xxArgType.noArgument.getIdNo())));
        return arrayList;
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new Function(this, "createFile", 1, OutputFileValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return new OutputFileValue(valueArray[0].getString(sourceRange), evaluationState);
            }
        });
        arrayList.add(new Function0Arg("List", sourceRange -> new ListValue(0)));
        arrayList.add(new Function1Arg("List", ListValue.invalid, (value, sourceRange) -> {
            if (value.hasIterator()) {
                return new ListValue(value.getIterator((SourceRange)sourceRange), (SourceRange)sourceRange);
            }
            if (value.hasDouble()) {
                return new ListValue(value.getInt((SourceRange)sourceRange));
            }
            throw new AsmErrorException("Cant get a number representations or a iterator representation from a value of type " + value.getType(), (SourceRange)sourceRange);
        }));
        arrayList.add(new Function0Arg("Hashtable", sourceRange -> new HashtableValue()));
        arrayList.add(new Function2Arg("CmdArgument", (value, value2, sourceRange) -> {
            if (value.isInvalid()) {
                throw new AsmErrorException("The type is an invalid value", (SourceRange)sourceRange);
            }
            if (!value2.isInvalid() && !value2.hasDouble()) {
                throw new AsmErrorException("a " + value.getType() + " is not a valid value argument", (SourceRange)sourceRange);
            }
            int n = value.getInt((SourceRange)sourceRange);
            _65xxArgType _65xxArgType2 = _65xxArgTypeUtil.getArgType(n, sourceRange);
            return new _65xxArgumentValue(_65xxArgType2, (Value)value2, NumberValue.zero);
        }));
        return arrayList;
    }
}

