/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.miscoutput;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.scope.ResolvedSymbol;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;

public class ByteDumpWriter {
    private EvaluationState state;
    private StringBuilder sb;
    private Comparator<ResolvedSymbol> symbolComp = new Comparator<ResolvedSymbol>(this){

        @Override
        public int compare(ResolvedSymbol resolvedSymbol, ResolvedSymbol resolvedSymbol2) {
            return Integer.compare(resolvedSymbol.address, resolvedSymbol2.address);
        }
    };
    private Map<String, List<String>> sourceFileLines = new HashMap<String, List<String>>();

    public void printSegments(String string, EvaluationState evaluationState) {
        List<ResolvedSymbol> list;
        this.state = evaluationState;
        this.sb = new StringBuilder();
        HashMap<String, ArrayList<ResolvedSymbol>> hashMap = new HashMap<String, ArrayList<ResolvedSymbol>>();
        for (ResolvedSymbol object : evaluationState.scopeMgr.getResolvedSymbols()) {
            list = (ArrayList<ResolvedSymbol>)hashMap.get(object.segment.getAbsoluteName());
            if (list == null) {
                list = new ArrayList<ResolvedSymbol>();
                hashMap.put(object.segment.getAbsoluteName(), (ArrayList<ResolvedSymbol>)list);
            }
            list.add(object);
        }
        for (Segment segment : evaluationState.segmentMgr.getSegments()) {
            if (segment.isHidden() || segment.isIntermediate()) continue;
            list = (List)hashMap.get(segment.getAbsoluteName());
            if (list == null) {
                list = new ArrayList();
            }
            Collections.sort(list, this.symbolComp);
            this.printSegment(segment, list);
        }
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream(string, false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(this.sb.toString());
            ((Writer)outputStreamWriter).close();
            outputStream.close();
        }
        catch (Exception exception) {
            throw new AsmErrorException("Error while creating ByteDump: " + exception.getMessage());
        }
    }

    private void printSegment(Segment segment, List<ResolvedSymbol> list) {
        int n;
        int n2 = segment.getMinAddress();
        for (n = 0; n < list.size(); ++n) {
            ResolvedSymbol resolvedSymbol = list.get(n);
            if (resolvedSymbol.address >= n2) break;
        }
        int n3 = 80;
        String string = " Segment: " + segment.getAbsoluteName() + " ";
        String string2 = "********************************************************************************";
        int n4 = Math.max(4, n3 - string.length());
        int n5 = n4 / 2;
        int n6 = n4 - n5;
        this.sb.append(string2.subSequence(0, n5));
        this.sb.append(string);
        this.sb.append(string2.subSequence(0, n6));
        this.sb.append("\n");
        boolean bl = true;
        for (SegmentMemoryBlock segmentMemoryBlock : segment.getOutputMemoryBlocks()) {
            if (!bl) {
                this.sb.append("\n");
            } else {
                bl = false;
            }
            String string3 = segmentMemoryBlock.getName();
            if (string3 == null) {
                string3 = "Unnamed";
            }
            this.sb.append("[" + string3 + "]\n");
            int n7 = segmentMemoryBlock.getStart();
            for (SegmentMemoryBlock.Entry entry : segmentMemoryBlock.getEntries()) {
                n = this.printBytes(entry, segmentMemoryBlock.isVirtual(), n7, list, n);
                n7 += entry.getBytes().length;
            }
        }
    }

    private int printBytes(SegmentMemoryBlock.Entry entry, boolean bl, int n, List<ResolvedSymbol> list, int n2) {
        int n3;
        Object object;
        int n4;
        byte[] byArray = entry.getBytes();
        SourceRange sourceRange = entry.getRange();
        int n5 = n + byArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (n4 = n2; n4 < list.size(); ++n4) {
            object = list.get(n4);
            if (((ResolvedSymbol)object).address >= n5) break;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(((ResolvedSymbol)object).name);
            int n6 = ((ResolvedSymbol)object).address - n;
            if (n6 == 0) continue;
            stringBuilder.append("-" + n6);
        }
        if (!bl2) {
            stringBuilder.append(":");
        }
        object = stringBuilder.toString();
        object = String.format("%1$-8s", object);
        String string = (String)object + this.getSourceString(sourceRange);
        int n7 = byArray.length <= 3 ? 3 : (byArray.length <= 64 ? 16 : 32);
        for (int i = n3 = 0; i < byArray.length; i += n7) {
            n = this.writeBytesLine(byArray, i, i + n7, string, bl, n);
            string = null;
        }
        return n4;
    }

    private int writeBytesLine(byte[] byArray, int n, int n2, String string, boolean bl, int n3) {
        if (bl) {
            this.sb.append("*");
        }
        this.sb.append(String.format("%04x: ", n3));
        for (int i = n; i < n2; ++i) {
            if (i >= byArray.length) {
                this.sb.append("   ");
                continue;
            }
            this.sb.append(String.format("%02x ", byArray[i]));
            ++n3;
        }
        if (string != null) {
            this.sb.append(" - ");
            this.sb.append(string);
        }
        this.sb.append("\n");
        return n3;
    }

    private List<String> getSourceFileLines(String string) throws IOException {
        String string2;
        List<String> list = this.sourceFileLines.get(string);
        if (list != null) {
            return list;
        }
        list = new ArrayList<String>();
        File file = this.state.fileMgr.getFile(string, false);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            list.add(string2);
        }
        bufferedReader.close();
        this.sourceFileLines.put(string, list);
        return list;
    }

    private String getSourceString(SourceRange sourceRange) {
        List<String> list = null;
        try {
            list = this.getSourceFileLines(sourceRange.getFileName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list == null) {
            return "";
        }
        int n = sourceRange.getStartLineNo() - 1;
        if (n >= list.size()) {
            return "";
        }
        String string = list.get(n);
        return string.substring(sourceRange.getStartLinePos() - 1);
    }
}

