/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.miscoutput;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.StringUtil;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.breakpoint.Breakpoint;
import kickass.state.breakpoint.Watchpoint;
import kickass.state.miscoutput.XmlWriter;
import kickass.state.scope.ResolvedSymbol;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;

public class DebugDumpWriter {
    public static void writePrg(String object, EvaluationState evaluationState, boolean bl) {
        if (!evaluationState.parameters.debugDump) {
            return;
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(46);
        if (n >= 0) {
            object2 = ((String)object2).substring(0, n);
        }
        object = (String)object2 + ".dbg";
        ParamBlock paramBlock = new ParamBlock();
        paramBlock.state = evaluationState;
        XmlWriter xmlWriter = paramBlock.out;
        xmlWriter.addOpenStartTag("C64debugger");
        xmlWriter.addArg("version", "1.0");
        xmlWriter.closeStartTag();
        DebugDumpWriter.printFiles(paramBlock);
        for (Segment object3 : evaluationState.segmentMgr.getSegments()) {
            if (object3.isIntermediate()) continue;
            DebugDumpWriter.printSegment(paramBlock, object3);
        }
        DebugDumpWriter.printLabels(paramBlock);
        DebugDumpWriter.printBreakpoints(paramBlock);
        DebugDumpWriter.printWatchpoints(paramBlock);
        xmlWriter.addEndTag();
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream((String)object, !bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(xmlWriter.getResult());
            ((Writer)outputStreamWriter).close();
            outputStream.close();
        }
        catch (AsmErrorException asmErrorException) {
            throw asmErrorException;
        }
        catch (Exception exception) {
            throw new AsmErrorException("Problem while writing file '" + (String)object + "': " + exception.getMessage(), null);
        }
    }

    private static void printFiles(ParamBlock paramBlock) {
        XmlWriter xmlWriter = paramBlock.out;
        xmlWriter.addOpenStartTag("Sources");
        xmlWriter.addArg("values", "INDEX,FILE");
        xmlWriter.closeStartTag();
        int n = 0;
        for (String string : paramBlock.state.fileMgr.getSourceFiles()) {
            paramBlock.fileMap.put(string, n);
            xmlWriter.addContentln(n + "," + string);
            ++n;
        }
        xmlWriter.addEndTag();
        xmlWriter.addEmptyLine();
    }

    private static void printSegment(ParamBlock paramBlock, Segment segment) {
        XmlWriter xmlWriter = paramBlock.out;
        xmlWriter.addOpenStartTag("Segment");
        xmlWriter.addArg("name", segment.getAbsoluteName());
        xmlWriter.addArg("dest", segment.getDestination());
        xmlWriter.addArg("values", "START,END,FILE_IDX,LINE1,COL1,LINE2,COL2");
        xmlWriter.closeStartTag();
        for (SegmentMemoryBlock segmentMemoryBlock : segment.getOutputMemoryBlocks_beforeModify()) {
            DebugDumpWriter.printMemBlock(paramBlock, segmentMemoryBlock);
        }
        xmlWriter.addEndTag();
        xmlWriter.addEmptyLine();
    }

    private static void printMemBlock(ParamBlock paramBlock, SegmentMemoryBlock segmentMemoryBlock) {
        XmlWriter xmlWriter = paramBlock.out;
        Map<String, Integer> map = paramBlock.fileMap;
        xmlWriter.addOpenStartTag("Block");
        xmlWriter.addArg("name", segmentMemoryBlock.getName());
        xmlWriter.closeStartTag();
        int n = segmentMemoryBlock.getStart();
        Iterator<SegmentMemoryBlock.Entry> iterator = segmentMemoryBlock.getEntries().iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            SegmentMemoryBlock.Entry entry = iterator.next();
            int n3 = n2 + entry.getBytes().length - 1;
            if (n2 > n3) continue;
            n = n3 + 1;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(StringUtil.toHex(n2));
            stringBuilder.append(",");
            stringBuilder.append(StringUtil.toHex(n3));
            stringBuilder.append(",");
            SourceRange sourceRange = entry.getRange();
            int n4 = sourceRange.getFileName() == null ? -1 : map.get(sourceRange.getFileName());
            stringBuilder.append(n4);
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLinePos());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLinePos());
            xmlWriter.addContentln(stringBuilder.toString());
        }
        xmlWriter.addEndTag();
    }

    private static void printBreakpoints(ParamBlock paramBlock) {
        XmlWriter xmlWriter = paramBlock.out;
        xmlWriter.addOpenStartTag("Breakpoints");
        xmlWriter.addArg("values", "SEGMENT,ADDRESS,ARGUMENT");
        xmlWriter.closeStartTag();
        for (Breakpoint breakpoint : paramBlock.state.breakpointMgr.getAllBreakpoints()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(breakpoint.segment.getAbsoluteName());
            stringBuilder.append(",");
            stringBuilder.append(StringUtil.toHex(breakpoint.address));
            stringBuilder.append(",");
            stringBuilder.append(breakpoint.argument == null ? "" : breakpoint.argument);
            xmlWriter.addContentln(stringBuilder.toString());
        }
        xmlWriter.addEndTag();
        xmlWriter.addEmptyLine();
    }

    private static void printWatchpoints(ParamBlock paramBlock) {
        XmlWriter xmlWriter = paramBlock.out;
        xmlWriter.addOpenStartTag("Watchpoints");
        xmlWriter.addArg("values", "SEGMENT,ADDRESS1,ADDRESS2,ARGUMENT");
        xmlWriter.closeStartTag();
        for (Watchpoint watchpoint : paramBlock.state.breakpointMgr.getAllWatchpoints()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(watchpoint.segment.getAbsoluteName());
            stringBuilder.append(",");
            stringBuilder.append(StringUtil.toHex(watchpoint.address1));
            stringBuilder.append(",");
            if (watchpoint.address2 != null) {
                stringBuilder.append(StringUtil.toHex(watchpoint.address2));
            }
            stringBuilder.append(",");
            if (watchpoint.argument != null) {
                stringBuilder.append(watchpoint.argument);
            }
            xmlWriter.addContentln(stringBuilder.toString());
        }
        xmlWriter.addEndTag();
        xmlWriter.addEmptyLine();
    }

    private static void printLabels(ParamBlock paramBlock) {
        XmlWriter xmlWriter = paramBlock.out;
        Map<String, Integer> map = paramBlock.fileMap;
        xmlWriter.addOpenStartTag("Labels");
        xmlWriter.addArg("values", "SEGMENT,ADDRESS,NAME,START,END,FILE_IDX,LINE1,COL1,LINE2,COL2");
        xmlWriter.closeStartTag();
        List<ResolvedSymbol> list = paramBlock.state.scopeMgr.getResolvedSymbols();
        for (ResolvedSymbol resolvedSymbol : list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(resolvedSymbol.segment.getAbsoluteName());
            stringBuilder.append(",");
            stringBuilder.append(StringUtil.toHex(resolvedSymbol.address));
            stringBuilder.append(",");
            stringBuilder.append(resolvedSymbol.name);
            stringBuilder.append(",");
            SourceRange sourceRange = resolvedSymbol.range;
            int n = sourceRange.getFileName() == null ? -1 : map.get(sourceRange.getFileName());
            stringBuilder.append(n);
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLinePos());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLinePos());
            xmlWriter.addContentln(stringBuilder.toString());
        }
        xmlWriter.addEndTag();
        xmlWriter.addEmptyLine();
    }

    static class ParamBlock {
        public XmlWriter out = new XmlWriter();
        public EvaluationState state;
        public Map<String, Integer> fileMap = new HashMap<String, Integer>();

        ParamBlock() {
        }
    }
}

