/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.miscoutput;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.StringUtil;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentMemoryBlock;

public class DebugDumpWriter_OLD {
    public static void writePrg(String object, EvaluationState evaluationState, Segment segment, boolean bl) {
        if (!evaluationState.parameters.debugDump) {
            return;
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(46);
        if (n >= 0) {
            object2 = ((String)object2).substring(0, n);
        }
        object = (String)object2 + ".dbg";
        ParamBlock paramBlock = new ParamBlock();
        paramBlock.state = evaluationState;
        DebugDumpWriter_OLD.printFiles(paramBlock);
        for (SegmentMemoryBlock object3 : segment.getOutputMemoryBlocks_beforeModify()) {
            DebugDumpWriter_OLD.printMemBlock(paramBlock, object3);
        }
        try {
            OutputStream outputStream = evaluationState.outputMgr.OpenOutputStream((String)object, !bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(paramBlock.sb.toString());
            ((Writer)outputStreamWriter).close();
            outputStream.close();
        }
        catch (AsmErrorException asmErrorException) {
            throw asmErrorException;
        }
        catch (Exception exception) {
            throw new AsmErrorException("Problem while writing file '" + (String)object + "': " + exception.getMessage(), null);
        }
    }

    private static void printFiles(ParamBlock paramBlock) {
        StringBuilder stringBuilder = paramBlock.sb;
        stringBuilder.append("# Files (with indexes)\n");
        stringBuilder.append("SOURCES={\n");
        int n = 0;
        for (String string : paramBlock.state.fileMgr.getSourceFiles()) {
            paramBlock.fileMap.put(string, n);
            stringBuilder.append(n);
            stringBuilder.append(",");
            stringBuilder.append(string);
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("}\n\n");
    }

    private static void printMemBlock(ParamBlock paramBlock, SegmentMemoryBlock segmentMemoryBlock) {
        StringBuilder stringBuilder = paramBlock.sb;
        Map<String, Integer> map = paramBlock.fileMap;
        stringBuilder.append("Block=" + segmentMemoryBlock.getName() + "\n");
        int n = segmentMemoryBlock.getStart();
        Iterator<SegmentMemoryBlock.Entry> iterator = segmentMemoryBlock.getEntries().iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            SegmentMemoryBlock.Entry entry = iterator.next();
            int n3 = n2 + entry.getBytes().length - 1;
            if (n2 > n3) continue;
            n = n3 + 1;
            stringBuilder.append(StringUtil.toHex(n2));
            stringBuilder.append(",");
            stringBuilder.append(StringUtil.toHex(n3));
            stringBuilder.append(",");
            SourceRange sourceRange = entry.getRange();
            int n4 = sourceRange.getFileName() == null ? -1 : map.get(sourceRange.getFileName());
            stringBuilder.append(n4);
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getStartLinePos());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLineNo());
            stringBuilder.append(",");
            stringBuilder.append(sourceRange.getEndLinePos());
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
    }

    static class ParamBlock {
        public StringBuilder sb = new StringBuilder();
        public EvaluationState state;
        public Map<String, Integer> fileMap = new HashMap<String, Integer>();

        ParamBlock() {
        }
    }
}

