/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.namespace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.values.NamespaceValue;
import kickass.plugins.interf.modifier.IModifier;
import kickass.state.EvaluationState;
import kickass.state.namespace.AnyMacro;
import kickass.state.namespace.AnySegmentModifier;
import kickass.state.scope.EntityScope;
import kickass.state.scope.StdEntityScope;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.scope.symboltable.SymbolTable;
import kickass.state.segments.Segment;

public class Namespace {
    private String name;
    public boolean isSpecial;
    private String fullName;
    private Namespace parent;
    private SymbolScope scope;
    private EntityScope<MacroDefinitionRootNode> pseudoCommands;
    private EntityScope<AnyMacro> macros;
    private EntityScope<IModifier> modifierPlugins;
    private EntityScope<AnySegmentModifier> segmentModifiers;
    private EntityScope<Segment> segments;
    private EntityScope<IFunctionSelector> functions;
    private Map<String, Namespace> subspaces = new HashMap<String, Namespace>();
    private Map<String, Namespace> globalSharedNamespaceMap;

    public static Namespace createSystemNamespace() {
        return new Namespace();
    }

    private Namespace() {
        this.fullName = this.name = "<SystemNs>";
        this.scope = new SymbolScope(null, new SymbolTable());
        this.macros = new StdEntityScope<AnyMacro>(null);
        this.pseudoCommands = new StdEntityScope<MacroDefinitionRootNode>(null);
        this.modifierPlugins = new StdEntityScope<IModifier>(null);
        this.segmentModifiers = new StdEntityScope<AnySegmentModifier>(null);
        this.functions = new StdEntityScope<IFunctionSelector>(null);
        this.segments = new StdEntityScope<Segment>(null);
        this.parent = null;
        this.isSpecial = true;
        this.globalSharedNamespaceMap = new HashMap<String, Namespace>();
    }

    public Namespace(String string, Namespace namespace, boolean bl) {
        this.name = string;
        this.isSpecial = bl;
        this.fullName = namespace.isSpecial ? string : namespace.getFullName() + "." + string;
        this.parent = namespace;
        this.globalSharedNamespaceMap = namespace.globalSharedNamespaceMap;
        this.scope = new SymbolScope(namespace.getScope(), null);
        this.macros = new StdEntityScope<AnyMacro>(namespace.getMacros());
        this.pseudoCommands = new StdEntityScope<MacroDefinitionRootNode>(namespace.getPseudoCommands());
        this.modifierPlugins = new StdEntityScope<IModifier>(namespace.getModifierPlugins());
        this.segmentModifiers = new StdEntityScope<AnySegmentModifier>(namespace.getSegmentModifiers());
        this.segments = new StdEntityScope<Segment>(namespace.segments);
        this.functions = new StdEntityScope<IFunctionSelector>(namespace.getFunctions());
    }

    public String toString() {
        return this.fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public SymbolScope getScope() {
        return this.scope;
    }

    public EntityScope<AnyMacro> getMacros() {
        return this.macros;
    }

    public EntityScope<IModifier> getModifierPlugins() {
        return this.modifierPlugins;
    }

    public EntityScope<AnySegmentModifier> getSegmentModifiers() {
        return this.segmentModifiers;
    }

    public EntityScope<MacroDefinitionRootNode> getPseudoCommands() {
        return this.pseudoCommands;
    }

    public EntityScope<IFunctionSelector> getFunctions() {
        return this.functions;
    }

    public EntityScope<Segment> getSegements() {
        return this.segments;
    }

    public Namespace getParent() {
        return this.parent;
    }

    public Namespace searchToRoot(Predicate<Namespace> predicate) {
        Namespace namespace;
        for (namespace = this; namespace != null; namespace = namespace.getParent()) {
            if (!predicate.test(namespace)) continue;
            return namespace;
        }
        return namespace;
    }

    public Namespace resolveNamepaceChain(List<Pair<String, SourceRange>> list, EvaluationState evaluationState) {
        String string = list.get(0).getA();
        Predicate<Namespace> predicate = namespace -> namespace.getSubspace(string) != null;
        Namespace namespace2 = this.searchToRoot(predicate);
        if (namespace2 == null) {
            SourceRange sourceRange = list.get(0).getB();
            evaluationState.diagnosticMgr.add(new AsmError("Can't resolve namespace '" + string + "'.", sourceRange));
            return null;
        }
        for (Pair<String, SourceRange> pair : list) {
            String string2 = pair.getA();
            if ((namespace2 = namespace2.getSubspace(string2)) != null) continue;
            SourceRange sourceRange = pair.getB();
            evaluationState.diagnosticMgr.add(new AsmError("Can't resolve namespace '" + string2 + "'.", sourceRange));
            return null;
        }
        return namespace2;
    }

    public Namespace getSubspace(String string) {
        return this.subspaces.get(string);
    }

    public Namespace getOrCreateSubspace(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        Object object = this.isSpecial ? string : this.fullName + "." + string;
        Namespace namespace = this.globalSharedNamespaceMap.get(object);
        if (namespace != null) {
            return namespace;
        }
        String[] stringArray = string.split(Pattern.quote("."));
        namespace = this;
        for (String string2 : stringArray) {
            if ((namespace = namespace.getOrCreateDirectSubspace(string2, evaluationState, sourceRange)) != null) continue;
            return null;
        }
        return namespace;
    }

    public Namespace getOrCreateDirectSubspace(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        Namespace namespace = this.subspaces.get(string);
        if (namespace != null) {
            return namespace;
        }
        if (this.scope.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't define namespace '" + string + "'. A symbol of that name is already defined.", sourceRange));
            return null;
        }
        Namespace namespace2 = new Namespace(string, this, false);
        ISymbolPageIdx iSymbolPageIdx = this.scope.define(string, iValueHolderArray -> new ConstantValueHolder(new NamespaceValue(namespace2, iValueHolderArray)));
        iSymbolPageIdx.setStatus(SymbolStatus.defined);
        iSymbolPageIdx.setIsScopeExposed(true);
        this.subspaces.put(string, namespace2);
        this.globalSharedNamespaceMap.put(namespace2.getFullName(), namespace2);
        return namespace2;
    }
}

