/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.namespace;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.NotImplementedException;
import kickass.nonasm.tools.collections.MultiEntryMap;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.functionselector.FunctionSelectorCreator;
import kickass.pass.function.functionselector.IFunctionSelector;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.SymbolStatus;

public class NamespaceManager {
    private EvaluationState state;
    private Namespace systemNamespace = Namespace.createSystemNamespace();
    private Namespace rootNamespace;
    private Namespace currentNamespace = this.rootNamespace = new Namespace("<RootNS>", this.systemNamespace, true);

    public NamespaceManager(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    public void setCurrentNamespace(Namespace namespace) {
        this.currentNamespace = namespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace replaceCurrentNamespace(Namespace namespace) {
        Namespace namespace2 = this.currentNamespace;
        this.currentNamespace = namespace;
        return namespace2;
    }

    public Namespace getSystemNamespace() {
        return this.systemNamespace;
    }

    public Namespace getRootOrCurrentNamespace(boolean bl) {
        return bl ? this.rootNamespace : this.currentNamespace;
    }

    public Namespace resolveNSPathForExtraction(NamespacePath namespacePath, EvaluationState evaluationState) {
        Namespace namespace = null;
        if (namespacePath.isRootRelative()) {
            namespace = this.rootNamespace;
        } else if (namespacePath.isRelative()) {
            namespace = this.currentNamespace;
        } else if (namespacePath.isParentRelative()) {
            namespace = this.currentNamespace;
            for (int i = namespacePath.noOfParentDots - 1; i > 0; --i) {
                if ((namespace = namespace.getParent()) != null) continue;
                evaluationState.diagnosticMgr.add(new AsmError("Too many dots. Space don't exist.", namespacePath.dotsRange));
                return null;
            }
        } else {
            throw new NotImplementedException();
        }
        if (namespacePath.pathIds.isEmpty()) {
            return namespace;
        }
        return namespace.resolveNamepaceChain(namespacePath.pathIds, evaluationState);
    }

    public Namespace resolveNSPathForDefinition(NamespacePath namespacePath, EvaluationState evaluationState) {
        if (namespacePath.isParentRelative()) {
            Namespace namespace = this.currentNamespace;
            for (int i = namespacePath.noOfParentDots; i > 1; --i) {
                if ((namespace = namespace.getParent()) != this.systemNamespace) continue;
                evaluationState.diagnosticMgr.add(new AsmError("Too many dots. Space don't exist.", namespacePath.dotsRange));
                return null;
            }
            return namespace;
        }
        if (namespacePath.isRelative() || namespacePath.isRootRelative()) {
            Namespace namespace = namespacePath.isRootRelative() ? this.rootNamespace : this.currentNamespace;
            for (Pair<String, SourceRange> pair : namespacePath.pathIds) {
                if ((namespace = namespace.getOrCreateDirectSubspace(pair.getA(), evaluationState, pair.getB())) != null) continue;
                return null;
            }
            return namespace;
        }
        throw new NotImplementedException();
    }

    public Namespace resolveNamespace(List<Pair<String, SourceRange>> list, EvaluationState evaluationState) {
        Namespace namespace;
        if (list == null || list.isEmpty()) {
            return this.currentNamespace;
        }
        String string = list.get(0).getA();
        Namespace namespace2 = null;
        for (namespace = this.currentNamespace; namespace != null && (namespace2 = namespace.getSubspace(string)) == null; namespace = namespace.getParent()) {
        }
        if (namespace2 == null) {
            SourceRange sourceRange = list.get(0).getB();
            evaluationState.diagnosticMgr.add(new AsmError("Can't resolve namespace '" + String.valueOf(namespace2) + "'.", sourceRange));
            return null;
        }
        namespace = namespace2;
        for (int i = 1; i < list.size(); ++i) {
            String string2 = list.get(i).getA();
            if ((namespace = namespace.getSubspace(string2)) != null) continue;
            SourceRange sourceRange = list.get(i).getB();
            evaluationState.diagnosticMgr.add(new AsmError("Can't resolve namespace '" + string2 + "'.", sourceRange));
            return null;
        }
        return namespace;
    }

    public void addLibrary(ILibrary iLibrary, Namespace namespace) {
        List<Function> list;
        String string = iLibrary.getClass().getSimpleName();
        for (LibConstant iterator : iLibrary.getConstants()) {
            SymbolScope symbolScope = namespace.getScope();
            if (symbolScope.isDefined(iterator.getName())) {
                list = "Error while adding the constant '" + iterator.getName() + "' from the library '" + string + "'. The symbol already exist!";
                this.state.diagnosticMgr.add(new AsmError((String)((Object)list), null));
                continue;
            }
            list = symbolScope.define(iterator.getName(), iValueHolderArray -> new ConstantValueHolder(iterator.getValue()));
            list.setStatus(SymbolStatus.defined);
        }
        MultiEntryMap multiEntryMap = new MultiEntryMap();
        for (Function function : iLibrary.getFunctions()) {
            multiEntryMap.add(function.getName(), function);
        }
        for (String string2 : multiEntryMap.keySet()) {
            list = multiEntryMap.get(string2);
            IFunctionSelector iFunctionSelector = FunctionSelectorCreator.create(list);
            namespace.getFunctions().put(string2, iFunctionSelector);
        }
    }
}

