/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.scope.symboltable.ISymbolInitializer;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;

public class SymbolScope {
    private SymbolScope parent;
    private ISymbolTable symbolTable;
    private Map<String, ISymbolPageIdx> localDefinedEntities = new HashMap<String, ISymbolPageIdx>();
    private Map<String, MultiSymbolDefinition> multiSymbols = new HashMap<String, MultiSymbolDefinition>();
    private ScopePosition scopePosition;

    public SymbolScope(SymbolScope symbolScope, ISymbolTable iSymbolTable) {
        this.parent = symbolScope;
        this.symbolTable = iSymbolTable != null ? iSymbolTable : symbolScope.getSymbolTable();
        this.scopePosition = symbolScope == null ? ScopePosition.inNamespace : symbolScope.getScopePosition();
    }

    public void setScopePosition(ScopePosition scopePosition) {
        this.scopePosition = scopePosition;
    }

    public Map<String, ISymbolPageIdx> getLocalDefinedEntities() {
        return this.localDefinedEntities;
    }

    public ScopePosition getScopePosition() {
        return this.scopePosition;
    }

    public boolean isDefined(String string) {
        return this.localDefinedEntities.containsKey(string);
    }

    public ISymbolPageIdx define(String string, ISymbolInitializer iSymbolInitializer) {
        ISymbolPageIdx iSymbolPageIdx = this.symbolTable.addValue(iSymbolInitializer, this.scopePosition);
        this.localDefinedEntities.put(string, iSymbolPageIdx);
        return iSymbolPageIdx;
    }

    public ISymbolPageIdx defineErrorIfExist(String string, ISymbolInitializer iSymbolInitializer, EvaluationState evaluationState, String string2, SourceRange sourceRange) {
        if (this.isDefined(string)) {
            evaluationState.diagnosticMgr.add(new AsmError(string2, sourceRange));
            return null;
        }
        return this.define(string, iSymbolInitializer);
    }

    public ISymbolPageIdx get(String string) {
        ISymbolPageIdx iSymbolPageIdx = this.localDefinedEntities.get(string);
        if (iSymbolPageIdx == null && this.parent != null) {
            iSymbolPageIdx = this.parent.get(string);
        }
        return iSymbolPageIdx;
    }

    public ISymbolPageIdx defineMultiSymbol(String string, ISymbolInitializer iSymbolInitializer) {
        MultiSymbolDefinition multiSymbolDefinition = this.multiSymbols.get(string);
        if (multiSymbolDefinition == null) {
            multiSymbolDefinition = new MultiSymbolDefinition(this);
            this.multiSymbols.put(string, multiSymbolDefinition);
        }
        ISymbolPageIdx iSymbolPageIdx = this.symbolTable.addValue(iSymbolInitializer, this.scopePosition);
        multiSymbolDefinition.labelIndexs.add(iSymbolPageIdx);
        return iSymbolPageIdx;
    }

    public void increaseMultiSymbolIdx(String string) {
        ++this.multiSymbols.get((Object)string).idx;
    }

    public ISymbolPageIdx getMultiSymbol(String string, int n) {
        MultiSymbolDefinition multiSymbolDefinition = this.multiSymbols.get(string);
        if (multiSymbolDefinition == null) {
            return this.parent == null ? null : this.parent.getMultiSymbol(string, n);
        }
        int n2 = multiSymbolDefinition.idx + n;
        if (n2 < 0) {
            return this.parent == null ? null : this.parent.getMultiSymbol(string, n2 + 1);
        }
        int n3 = n2 - multiSymbolDefinition.labelIndexs.size() + 1;
        if (n3 > 0) {
            return this.parent == null ? null : this.parent.getMultiSymbol(string, n3);
        }
        return multiSymbolDefinition.labelIndexs.get(n2);
    }

    public SymbolScope getParent() {
        return this.parent;
    }

    public ISymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private class MultiSymbolDefinition {
        public int idx = -1;
        public List<ISymbolPageIdx> labelIndexs = new ArrayList<ISymbolPageIdx>();

        private MultiSymbolDefinition(SymbolScope symbolScope) {
        }
    }
}

