/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.nonasm.tools.StringUtil;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.parsing.sourcelocation.misc.StringRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.Constant;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.NullValue;
import kickass.pass.values.SegmentValue;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginEngine;
import kickass.plugins.impl.PluginMemoryBlock;
import kickass.plugins.impl.PluginParameterMap;
import kickass.plugins.interf.general.IMemoryBlock;
import kickass.state.EvaluationState;
import kickass.state.namespace.AnySegmentModifier;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentMemoryBlock;
import kickass.state.segments.resolvers.IStartResolver;

public class Segment {
    private String absoluteName;
    private SourceRange range;
    public boolean isInitialized = false;
    private boolean isIntemediate = false;
    private boolean isDefault = false;
    private boolean isHidden = false;
    private AnySegmentModifier modifier = null;
    private ParameterMap modifierArgs = null;
    private Value bank = NullValue.instance;
    private String loadInto = "";
    private String destination = "";
    private IStartResolver defaultBlockStartResolver = SegmentManager.defaultStartResolver;
    private Integer align = null;
    private boolean isVirtual = false;
    private String outPrg;
    private String outBin;
    public List<Segment> subsegments = new ArrayList<Segment>();
    private Segment lastLoadedSegment = null;
    private byte fillByte = 0;
    private boolean allowOverlap = false;
    private int min = 0;
    private int max = -1;
    private boolean fill = false;
    private SegmentMemoryBlock defaultBlock;
    private SegmentMemoryBlock currentBlock;
    private List<SegmentMemoryBlock> inputMemoryBlocks = new ArrayList<SegmentMemoryBlock>();
    private List<SegmentMemoryBlock> outputMemoryBlocks_beforeModify = new ArrayList<SegmentMemoryBlock>();
    private List<SegmentMemoryBlock> outputMemoryBlocks = this.outputMemoryBlocks_beforeModify;
    private SegmentMemoryBlock lastBlok;
    private int currentPc = -1;
    boolean isClosed = false;
    boolean isFinalized = false;
    boolean finalizedWithErrors = false;
    public boolean isFinalizing = false;
    private boolean traversingSubSegments = false;
    private static Comparator<SegmentMemoryBlock> lowestBlockComparator = new Comparator<SegmentMemoryBlock>(){

        @Override
        public int compare(SegmentMemoryBlock segmentMemoryBlock, SegmentMemoryBlock segmentMemoryBlock2) {
            int n = Integer.compare(segmentMemoryBlock.getStart(), segmentMemoryBlock2.getStart());
            if (n != 0) {
                return n;
            }
            int n2 = Integer.compare(segmentMemoryBlock2.getLevel(), segmentMemoryBlock.getLevel());
            if (n2 != 0) {
                return n2;
            }
            return Long.compare(segmentMemoryBlock2.getSequenceNo(), segmentMemoryBlock.getSequenceNo());
        }
    };

    public Segment(String string, SourceRange sourceRange) {
        this.absoluteName = string;
        this.range = sourceRange;
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public String getOutPrg() {
        return this.outPrg;
    }

    public String getOutBin() {
        return this.outBin;
    }

    public boolean getAllowOverlappingMemoryBlocks() {
        return this.allowOverlap;
    }

    public byte getFillByte() {
        return this.fillByte;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isIntermediate() {
        return this.isIntemediate;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public SourceRange getRange() {
        return this.range;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean getFillMinMax() {
        return this.fill;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean hasDefaultStartResolver() {
        return this.defaultBlockStartResolver == SegmentManager.defaultStartResolver;
    }

    public Segment getLastLoadedSegment() {
        return this.lastLoadedSegment;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public Integer getAlign() {
        return this.align;
    }

    public Value getBank() {
        return this.bank;
    }

    public String getLoadInto() {
        return this.loadInto;
    }

    public void setIsVirtual(boolean bl) {
        this.isVirtual = bl;
    }

    public void setIsHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void setOutPrg(String string) {
        this.outPrg = string;
    }

    public void setOutBin(String string) {
        this.outBin = string;
    }

    public void setModifier(AnySegmentModifier anySegmentModifier) {
        this.modifier = anySegmentModifier;
    }

    public void setModifierArgs(ParameterMap parameterMap) {
        this.modifierArgs = parameterMap;
    }

    public void setAllowOverlappingMemoryBlocks(boolean bl) {
        this.allowOverlap = bl;
    }

    public void setMin(int n) {
        this.min = Math.max(n, 0);
    }

    public void setMax(int n) {
        this.max = n;
    }

    public void setFillByte(byte by) {
        this.fillByte = by;
    }

    public void setIsDefault(boolean bl) {
        this.isDefault = bl;
    }

    public void setIsIntermediate(boolean bl) {
        this.isIntemediate = bl;
    }

    public void setStartResolver(IStartResolver iStartResolver) {
        this.defaultBlockStartResolver = iStartResolver;
    }

    public void setBank(Value value) {
        this.bank = value;
    }

    public void setLoadInto(String string) {
        this.loadInto = string;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
    }

    public void setLastLoadedSegmant(Segment segment) {
        this.lastLoadedSegment = segment;
    }

    public void setAlign(Integer n) {
        this.align = n;
    }

    public void initPass() {
        if (this.defaultBlock == null) {
            this.defaultBlock = new SegmentMemoryBlock(this.absoluteName, this.isVirtual);
            this.defaultBlock.setStartResolver(this.defaultBlockStartResolver);
            this.inputMemoryBlocks.add(this.defaultBlock);
        }
        this.currentBlock = this.defaultBlock;
        this.currentPc = this.defaultBlock.getStart();
    }

    public void close(EvaluationState evaluationState) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.lastBlok = this.currentBlock;
        this.currentBlock.closeForNewEntries();
        evaluationState.setMadeMetaProgress();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void addMemoryBlock(SegmentMemoryBlock segmentMemoryBlock) {
        if (this.isClosed) {
            throw new RuntimeException("Can't add memoryblocks to a closed segment!");
        }
        this.inputMemoryBlocks.add(segmentMemoryBlock);
    }

    public void setCurrentMemoryBlock(SegmentMemoryBlock segmentMemoryBlock) {
        this.currentBlock = segmentMemoryBlock;
    }

    public SegmentMemoryBlock getCurrentMemoryBlock() {
        return this.currentBlock;
    }

    public List<SegmentMemoryBlock> getOutputMemoryBlocks() {
        this.ensureFinalized();
        return this.outputMemoryBlocks;
    }

    public List<SegmentMemoryBlock> getOutputMemoryBlocks_beforeModify() {
        this.ensureFinalized();
        return this.outputMemoryBlocks;
    }

    public List<SegmentMemoryBlock> getInputMemoryBlocks() {
        this.ensureFinalized();
        return this.inputMemoryBlocks;
    }

    public int getMemoryPosition() {
        return this.currentPc;
    }

    public void invalidateMemoryPos() {
        this.currentPc = -1;
    }

    public void setMemoryPosition(int n) {
        this.currentPc = n;
    }

    public void increaseMemoryPosition(int n) {
        if (this.currentPc >= 0) {
            this.currentPc += n;
        }
    }

    public int getResolvedEndPc() {
        if (!this.isClosed) {
            return -1;
        }
        return this.lastBlok.getEnd();
    }

    public boolean isReadyToFinalize(EvaluationState evaluationState) {
        if (!this.isInitialized) {
            return false;
        }
        if (this.modifierArgs != null && this.modifierArgs.anyInvalidValues()) {
            return false;
        }
        for (SegmentMemoryBlock object : this.inputMemoryBlocks) {
            if (object.isFinished()) continue;
            return false;
        }
        if (this.traversingSubSegments) {
            return true;
        }
        for (Segment segment : this.subsegments) {
            this.traversingSubSegments = true;
            boolean bl = segment.isReadyToFinalize(evaluationState);
            this.traversingSubSegments = false;
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean finalize(EvaluationState evaluationState) {
        return this.finalize(evaluationState, new Stack<Segment>());
    }

    /*
     * WARNING - void declaration
     */
    public boolean finalize(EvaluationState evaluationState, Stack<Segment> stack) {
        if (this.isFinalized) {
            return this.finalizedWithErrors;
        }
        if (!this.isClosed) {
            throw new ShouldNotBeHereException("Trying to finish an open segment (" + this.absoluteName + ").");
        }
        if (this.isFinalizing) {
            Object object = this.absoluteName;
            for (int i = stack.size() - 1; i >= 0; --i) {
                Segment segment = (Segment)stack.get(i);
                object = segment.absoluteName + "->" + (String)object;
                if (segment == this) break;
            }
            evaluationState.diagnosticMgr.add(new AsmError("Circular dependant segments: " + (String)object, this.range));
            return false;
        }
        if (this.defaultBlock.isEmpty()) {
            this.inputMemoryBlocks.remove(this.defaultBlock);
        }
        this.inputMemoryBlocks.sort(SegmentMemoryBlock.comparator);
        PriorityQueue<SegmentMemoryBlock> priorityQueue = new PriorityQueue<SegmentMemoryBlock>(this.inputMemoryBlocks.size() + 10, lowestBlockComparator);
        for (SegmentMemoryBlock object : this.inputMemoryBlocks) {
            if (!object.isFinished()) {
                throw new ShouldNotBeHereException("Trying to finish unfinished memoryblock.");
            }
            if (object.isVirtual()) {
                boolean iterator;
                boolean bl = iterator = object.getStart() < this.min || this.max >= 0 && this.max < object.getEnd() - 1;
                if (!iterator) continue;
                String segment = "(" + StringUtil.toHex(this.min) + "-" + (this.max < 0 ? " " : StringUtil.toHex(this.max)) + ")";
                String bl2 = this.blockToString(object);
                evaluationState.diagnosticMgr.add(new AsmError("In segment '" + this.getAbsoluteName() + "' the memoryblock " + bl2 + " is out of segment bounds " + segment + ".", null));
                continue;
            }
            if (object.isEmpty()) continue;
            priorityQueue.add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (Segment segment : this.subsegments) {
            this.isFinalizing = true;
            stack.push(this);
            boolean segmentMemoryBlock = segment.finalize(evaluationState, stack);
            stack.pop();
            this.isFinalizing = false;
            if (segmentMemoryBlock) {
                segmentMemoryBlock = true;
                continue;
            }
            arrayList.add(segment);
        }
        boolean bl = true;
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            void var5_11;
            Segment segment = (Segment)iterator.next();
            void var8_20 = ++var5_11;
            for (SegmentMemoryBlock segmentMemoryBlock : segment.getOutputMemoryBlocks()) {
                segmentMemoryBlock.setLevel((int)var8_20);
                priorityQueue.add(segmentMemoryBlock);
            }
        }
        this.outputMemoryBlocks_beforeModify = this.detectAndCutOverlap(priorityQueue, evaluationState);
        if (this.fill) {
            this.outputMemoryBlocks_beforeModify = this.addFillBlocks(this.outputMemoryBlocks_beforeModify);
        }
        for (SegmentMemoryBlock segmentMemoryBlock : this.outputMemoryBlocks_beforeModify) {
            boolean bl3;
            if (segmentMemoryBlock.isEmpty()) continue;
            boolean bl4 = bl3 = segmentMemoryBlock.getStart() < this.min || this.max >= 0 && this.max < segmentMemoryBlock.getEnd() - 1;
            if (!bl3) continue;
            String string = "(" + StringUtil.toHex(this.min) + "-" + (this.max < 0 ? " " : StringUtil.toHex(this.max)) + ")";
            String string2 = this.blockToString(segmentMemoryBlock);
            evaluationState.diagnosticMgr.add(new AsmError("In segment '" + this.getAbsoluteName() + "' the memoryblock " + string2 + " is out of segment bounds " + (String)string + ".", null));
        }
        this.outputMemoryBlocks = this.modifier == null ? this.outputMemoryBlocks_beforeModify : this.executeModifier(this.modifier, this.outputMemoryBlocks_beforeModify, evaluationState);
        this.isFinalized = true;
        return this.finalizedWithErrors;
    }

    private List<SegmentMemoryBlock> executeModifier(AnySegmentModifier anySegmentModifier, List<SegmentMemoryBlock> list, EvaluationState evaluationState) {
        if (anySegmentModifier.plugin != null) {
            List<IMemoryBlock> list2 = PluginMemoryBlock.createList(list);
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.range);
            List<IMemoryBlock> list3 = anySegmentModifier.plugin.execute(list2, new PluginParameterMap(this.modifierArgs), pluginEngine);
            PriorityQueue<SegmentMemoryBlock> priorityQueue = Segment.toSegmentMemoryBlockHeap(list3, this.range);
            return this.detectAndCutOverlap(priorityQueue, evaluationState);
        }
        int n = 0;
        if (anySegmentModifier.script != null) {
            Segment segment = evaluationState.segmentMgr.getCurrentSegment();
            Segment segment2 = new Segment("<<.modifiersegment:" + n++ + ">>", this.range);
            segment2.setIsIntermediate(true);
            segment2.initPass();
            evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment2);
            IValueHolder[] iValueHolderArray = anySegmentModifier.script.getInnerScope().getSymbolTable().createPage();
            ArrayList<ExprNode> arrayList = new ArrayList<ExprNode>();
            arrayList.add(new Constant(new SegmentValue(this, list), this.range));
            for (StringRange stringRange : anySegmentModifier.script.getUserArgumentNames()) {
                ExprNode exprNode = this.modifierArgs.getExpr(stringRange.string);
                if (exprNode == null) {
                    exprNode = new Constant(NullValue.instance, stringRange.range);
                }
                arrayList.add(exprNode);
            }
            AsmNode asmNode = anySegmentModifier.script.instantiate(arrayList, NullValue.instance, iValueHolderArray, this.range).executePass(evaluationState);
            if (!asmNode.isFinished()) {
                new ShouldNotBeHereException("Script segment notifier node didn't finish!");
            }
            segment2.close(evaluationState);
            evaluationState.segmentMgr.switchToSegmentWithoutSideEffect(segment);
            segment2.finalize(evaluationState);
            return segment2.getOutputMemoryBlocks();
        }
        throw new ShouldNotBeHereException("Unhandled segment modifier type");
    }

    private ArrayList<SegmentMemoryBlock> addFillBlocks(List<SegmentMemoryBlock> list) {
        ArrayList<SegmentMemoryBlock> arrayList = new ArrayList<SegmentMemoryBlock>();
        int n = this.min;
        for (SegmentMemoryBlock segmentMemoryBlock : list) {
            int n2 = segmentMemoryBlock.getStart() - n;
            if (n2 > 0) {
                arrayList.add(this.createFillBlock(n, n2));
            }
            n = Math.max(n, segmentMemoryBlock.getEnd());
            arrayList.add(segmentMemoryBlock);
        }
        int n3 = this.max - n + 1;
        if (n3 > 0) {
            arrayList.add(this.createFillBlock(n, n3));
        }
        return arrayList;
    }

    private SegmentMemoryBlock createFillBlock(int n, int n2) {
        SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock("FillMinMax", 0L, n);
        byte[] byArray = new byte[n2];
        if (this.fillByte != 0) {
            Arrays.fill(byArray, this.fillByte);
        }
        segmentMemoryBlock.addDoneEntry(byArray, this.range);
        segmentMemoryBlock.closeForNewEntries();
        return segmentMemoryBlock;
    }

    private ArrayList<SegmentMemoryBlock> detectAndCutOverlap(PriorityQueue<SegmentMemoryBlock> priorityQueue, EvaluationState evaluationState) {
        ArrayList<SegmentMemoryBlock> arrayList = new ArrayList<SegmentMemoryBlock>(priorityQueue.size() + 10);
        SegmentMemoryBlock segmentMemoryBlock = priorityQueue.poll();
        while (segmentMemoryBlock != null) {
            boolean bl;
            SegmentMemoryBlock segmentMemoryBlock2 = priorityQueue.poll();
            if (segmentMemoryBlock2 == null) {
                arrayList.add(segmentMemoryBlock);
                break;
            }
            boolean bl2 = bl = segmentMemoryBlock.isEmpty() || segmentMemoryBlock2.isEmpty();
            if (bl || segmentMemoryBlock.getEnd() <= segmentMemoryBlock2.getStart()) {
                arrayList.add(segmentMemoryBlock);
                segmentMemoryBlock = segmentMemoryBlock2;
                continue;
            }
            if (!this.allowOverlap) {
                SegmentMemoryBlock segmentMemoryBlock3 = segmentMemoryBlock;
                SegmentMemoryBlock segmentMemoryBlock4 = segmentMemoryBlock2;
                String string = this.blockToString(segmentMemoryBlock3);
                String string2 = this.blockToString(segmentMemoryBlock4);
                String string3 = "In segment '" + this.getAbsoluteName() + "' the memoryblock " + string + " overlaps " + string2;
                evaluationState.diagnosticMgr.add(new AsmError(string3, null));
                this.finalizedWithErrors = true;
            }
            segmentMemoryBlock = this.cutBlock(segmentMemoryBlock, segmentMemoryBlock2, priorityQueue);
        }
        return arrayList;
    }

    private String blockToString(SegmentMemoryBlock segmentMemoryBlock) {
        return "'" + segmentMemoryBlock.getName() + "' (" + StringUtil.toHex(segmentMemoryBlock.getStart()) + "-" + StringUtil.toHex(segmentMemoryBlock.getEnd() - 1) + ")";
    }

    private SegmentMemoryBlock cutBlock(SegmentMemoryBlock segmentMemoryBlock, SegmentMemoryBlock segmentMemoryBlock2, PriorityQueue<SegmentMemoryBlock> priorityQueue) {
        Object object;
        boolean bl;
        int n = Integer.compare(segmentMemoryBlock.getLevel(), segmentMemoryBlock2.getLevel());
        if (n == 0) {
            n = Long.compare(segmentMemoryBlock.getSequenceNo(), segmentMemoryBlock2.getSequenceNo());
        }
        boolean bl2 = bl = n >= 0;
        if (bl) {
            int n2;
            Object object2;
            if (segmentMemoryBlock2.getEnd() <= segmentMemoryBlock.getEnd()) {
                return segmentMemoryBlock;
            }
            int n3 = segmentMemoryBlock.getEnd() - segmentMemoryBlock2.getStart();
            List<SegmentMemoryBlock.Entry> list = segmentMemoryBlock2.getEntries();
            for (n2 = 0; n2 < list.size() && ((SegmentMemoryBlock.Entry)(object2 = list.get(n2))).getBytes().length <= n3; n3 -= ((SegmentMemoryBlock.Entry)object2).getBytes().length, ++n2) {
            }
            object2 = new SegmentMemoryBlock(segmentMemoryBlock2.getName(), segmentMemoryBlock2.getSequenceNo(), segmentMemoryBlock.getEnd());
            if (n3 > 0) {
                SegmentMemoryBlock.Entry entry = list.get(n2);
                byte[] byArray = entry.getBytes();
                int n4 = byArray.length - n3;
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                ((SegmentMemoryBlock)object2).addDoneEntry(byArray2, entry.getRange());
                ++n2;
            }
            while (n2 < list.size()) {
                ((SegmentMemoryBlock)object2).addDoneEntry(list.get(n2));
                ++n2;
            }
            ((SegmentMemoryBlock)object2).closeForNewEntries();
            priorityQueue.add((SegmentMemoryBlock)object2);
            return segmentMemoryBlock;
        }
        int n5 = segmentMemoryBlock2.getStart() - segmentMemoryBlock.getStart();
        SegmentMemoryBlock segmentMemoryBlock3 = new SegmentMemoryBlock(segmentMemoryBlock.getName(), segmentMemoryBlock.getSequenceNo(), segmentMemoryBlock.getStart());
        for (SegmentMemoryBlock.Entry entry : segmentMemoryBlock.getEntries()) {
            if (n5 >= entry.getBytes().length) {
                segmentMemoryBlock3.addDoneEntry(entry);
            } else {
                int n6 = n5;
                byte[] byArray = entry.getBytes();
                object = new byte[n6];
                System.arraycopy(byArray, 0, object, 0, n6);
                segmentMemoryBlock3.addDoneEntry((byte[])object, entry.getRange());
            }
            if ((n5 -= entry.getBytes().length) > 0) continue;
            break;
        }
        segmentMemoryBlock3.closeForNewEntries();
        int n7 = segmentMemoryBlock.getEnd() - segmentMemoryBlock2.getEnd();
        if (n7 > 0) {
            int n8;
            int n9;
            int n10 = segmentMemoryBlock2.getEnd() - segmentMemoryBlock.getStart();
            List<SegmentMemoryBlock.Entry> list = segmentMemoryBlock.getEntries();
            for (n8 = 0; n8 < list.size() && (n9 = ((SegmentMemoryBlock.Entry)(object = (Object)list.get(n8))).getBytes().length) <= n10; n10 -= n9, ++n8) {
            }
            object = new SegmentMemoryBlock(segmentMemoryBlock.getName(), segmentMemoryBlock.getSequenceNo(), segmentMemoryBlock2.getEnd());
            if (n10 > 0) {
                SegmentMemoryBlock.Entry entry = list.get(n8);
                byte[] byArray = entry.getBytes();
                int n11 = byArray.length - n10;
                byte[] byArray3 = new byte[n11];
                System.arraycopy(byArray, n10, byArray3, 0, n11);
                ((SegmentMemoryBlock)object).addDoneEntry(byArray3, entry.getRange());
                ++n8;
            }
            while (n8 < list.size()) {
                ((SegmentMemoryBlock)object).addDoneEntry(list.get(n8));
                ++n8;
            }
            ((SegmentMemoryBlock)object).closeForNewEntries();
            priorityQueue.add((SegmentMemoryBlock)object);
        }
        priorityQueue.add(segmentMemoryBlock2);
        return segmentMemoryBlock3;
    }

    private void ensureFinalized() {
        if (!this.isFinalized) {
            throw new RuntimeException("Non finalized segment: " + this.absoluteName);
        }
    }

    public boolean isEmpty() {
        this.ensureFinalized();
        return this.outputMemoryBlocks.isEmpty();
    }

    public int getMinAddress() {
        this.ensureFinalized();
        return this.outputMemoryBlocks.isEmpty() ? 0 : this.outputMemoryBlocks.get(0).getStart();
    }

    public int getMaxAddress() {
        this.ensureFinalized();
        return this.outputMemoryBlocks.isEmpty() ? 0 : this.outputMemoryBlocks.get(this.outputMemoryBlocks.size() - 1).getEnd();
    }

    public boolean hasSameContent(Segment segment, boolean bl) {
        this.ensureFinalized();
        segment.ensureFinalized();
        int n = this.outputMemoryBlocks.size();
        if (n != segment.outputMemoryBlocks.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.outputMemoryBlocks.get(i).hasSameContent(segment.outputMemoryBlocks.get(i), bl)) continue;
            return false;
        }
        return true;
    }

    public boolean flattenAreEqual(Segment segment) {
        byte[] byArray = this.flatten(true);
        byte[] byArray2 = segment.flatten(true);
        return Arrays.equals(byArray, byArray2);
    }

    public byte[] flatten(boolean bl) {
        this.ensureFinalized();
        int n = this.getMinAddress();
        int n2 = this.getMaxAddress();
        int n3 = bl ? 2 : 0;
        byte[] byArray = new byte[n2 - n + n3];
        if (bl) {
            byArray[0] = (byte)n;
            byArray[1] = (byte)(n >> 8);
        }
        for (SegmentMemoryBlock segmentMemoryBlock : this.outputMemoryBlocks) {
            byte[] byArray2 = segmentMemoryBlock.getBytes();
            System.arraycopy(byArray2, 0, byArray, segmentMemoryBlock.getStart() - n + n3, byArray2.length);
        }
        return byArray;
    }

    public static PriorityQueue<SegmentMemoryBlock> toSegmentMemoryBlockHeap(List<IMemoryBlock> list, SourceRange sourceRange) {
        PriorityQueue<SegmentMemoryBlock> priorityQueue = new PriorityQueue<SegmentMemoryBlock>(list.size() + 10, lowestBlockComparator);
        for (IMemoryBlock iMemoryBlock : list) {
            SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock(iMemoryBlock.getName(), false);
            segmentMemoryBlock.setStart(iMemoryBlock.getStartAddress());
            segmentMemoryBlock.addDoneEntry(iMemoryBlock.getBytes(), sourceRange);
            segmentMemoryBlock.closeForNewEntries();
            priorityQueue.add(segmentMemoryBlock);
        }
        return priorityQueue;
    }
}

