/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.c64.SidFile;
import kickass.nonasm.tools.StreamUtil;
import kickass.nonasm.tools.StringUtil;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.misc.NamespacePathParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.plugins.impl.PluginValue;
import kickass.plugins.interf.general.IValue;
import kickass.state.EvaluationState;
import kickass.state.namespace.AnySegmentModifier;
import kickass.state.namespace.Namespace;
import kickass.state.namespace.NamespacePath;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentManager;
import kickass.state.segments.SegmentMemoryBlock;
import kickass.state.segments.resolvers.AfterSegmentStartResolver;
import kickass.state.segments.resolvers.ConstantStartResolver;
import kickass.state.segments.resolvers.IStartResolver;

public class SegmentParser {
    public static final String param_prgFiles = "prgFiles";
    public static final String param_sidFiles = "sidFiles";
    public static final String param_allowOverlap = "allowOverlap";
    public static final String param_modify = "modify";
    public static final String param_segments = "segments";
    public static final String param_min = "min";
    public static final String param_max = "max";
    public static final String param_fill = "fill";
    public static final String param_fillByte = "fillByte";
    public static final String param_hide = "hide";
    public static final String param_start = "start";
    public static final String param_startAfter = "startAfter";
    public static final String param_virtual = "virtual";
    public static final String param_align = "align";
    public static final String param_outPrg = "outPrg";
    public static final String param_outBin = "outBin";
    public static final String param_dest = "dest";
    public static final String param_bank = "bank";
    public static final String param_loadInto = "loadInto";
    public static final Set<String> combiParameters;
    public static final Set<String> codeInputParameters;

    public static Segment fillGeneralSegment(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        boolean bl;
        boolean bl2;
        segment.setIsHidden(parameterMap.getBoolValue(param_hide, false));
        segment.setMin(parameterMap.getIntValue(param_min, 0));
        segment.setMax(parameterMap.getIntValue(param_max, -1));
        segment.setAllowOverlappingMemoryBlocks(parameterMap.getBoolValue(param_allowOverlap, false));
        segment.setFill(parameterMap.getBoolValue(param_fill, false));
        segment.setFillByte((byte)parameterMap.getIntValue(param_fillByte, 0));
        boolean bl3 = bl2 = parameterMap.exist(param_min) && parameterMap.exist(param_max);
        if (bl2 && segment.getMin() > segment.getMax()) {
            evaluationState.diagnosticMgr.add(new AsmError("Min can't be greater than max. Min=" + StringUtil.toHex(segment.getMin()) + ", max=" + StringUtil.toHex(segment.getMax()), parameterMap.getNameRange(param_min)));
        }
        boolean bl4 = bl = parameterMap.exist(param_fill) && (!parameterMap.exist(param_min) || !parameterMap.exist(param_max));
        if (bl) {
            segment.setFill(false);
            evaluationState.diagnosticMgr.add(new AsmError("Can't use fill without both min and max", parameterMap.getNameRange(param_fill)));
        }
        if ((string = parameterMap.getStringValue(param_prgFiles)) != null) {
            object5 = parameterMap.getNameRange(param_prgFiles);
            object3 = object4 = string.split(",");
            int n = ((String[])object3).length;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, byte[]> object6;
                String string2 = object3[i];
                if ((string2 = string2.trim()).isEmpty() || (object6 = SegmentParser.loadPrgFile(string2, (SourceRange)object5, evaluationState)) == null) continue;
                object2 = new File(string2).getName();
                object = new SegmentMemoryBlock((String)object2, false);
                ((SegmentMemoryBlock)object).setStart(object6.getA());
                ((SegmentMemoryBlock)object).addDoneEntry(object6.getB(), (SourceRange)object5);
                ((SegmentMemoryBlock)object).closeForNewEntries();
                segment.addMemoryBlock((SegmentMemoryBlock)object);
            }
        }
        if ((object5 = parameterMap.getStringValue(param_sidFiles)) != null) {
            object4 = parameterMap.getNameRange(param_sidFiles);
            for (String string2 : object3 = ((String)object5).split(",")) {
                String string3 = string2.trim();
                if (string3.isEmpty() || (object2 = SegmentParser.loadSidFile(string3, (SourceRange)object4, evaluationState)) == null) continue;
                object = new File(string3).getName();
                SegmentMemoryBlock segmentMemoryBlock = new SegmentMemoryBlock((String)object, false);
                segmentMemoryBlock.setStart(((SidFile)object2).getLocation());
                segmentMemoryBlock.addDoneEntry(((SidFile)object2).getData(), (SourceRange)object4);
                segmentMemoryBlock.closeForNewEntries();
                segment.addMemoryBlock(segmentMemoryBlock);
            }
        }
        if (parameterMap.exist(param_segments)) {
            object4 = parameterMap.getStringValue(param_segments).split(",");
            object3 = parameterMap.getNameRange(param_segments);
            for (String string4 : object4) {
                String string5 = string4.trim();
                if (string5.isEmpty() || (object2 = evaluationState.segmentMgr.resolveSegment(string5, evaluationState, (SourceRange)object3)) == null) continue;
                segment.subsegments.add((Segment)object2);
            }
        }
        if ((object4 = SegmentParser.resolveModifier(parameterMap, evaluationState, true)) != null) {
            segment.setModifier((AnySegmentModifier)object4);
            segment.setModifierArgs(parameterMap);
        }
        return segment;
    }

    private static void addModifierArgs(ParameterMap parameterMap, ArrayList<IValue> arrayList, String string, int n) {
        if (!parameterMap.exist(string)) {
            return;
        }
        while (arrayList.size() <= n) {
            arrayList.add(new PluginValue(NullValue.instance, null));
        }
        PluginValue pluginValue = new PluginValue(parameterMap.getValue(string), parameterMap.getNameRange(string));
        arrayList.set(n, pluginValue);
    }

    private static Pair<Integer, byte[]> loadPrgFile(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        InputStream inputStream = evaluationState.fileMgr.openFile(string, false);
        if (inputStream == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't open file '" + string + "'", sourceRange));
            return null;
        }
        byte[] byArray = new byte[2];
        int n = 0;
        try {
            n = inputStream.read(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 2) {
            evaluationState.diagnosticMgr.add(new AsmError("File '" + string + "' is too short. Must contain at least two address bytes.", sourceRange));
            return null;
        }
        int n2 = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        byte[] byArray2 = StreamUtil.readBytes(inputStream);
        if (byArray2 == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't read file '" + string + "'", sourceRange));
            return null;
        }
        return new Pair<Integer, byte[]>(n2, byArray2);
    }

    private static SidFile loadSidFile(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        InputStream inputStream = evaluationState.fileMgr.openFile(string, false);
        if (inputStream == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't open file '" + string + "'", sourceRange));
            return null;
        }
        byte[] byArray = StreamUtil.readBytes(inputStream);
        if (byArray == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Can't read file '" + string + "'", sourceRange));
            return null;
        }
        return new SidFile(byArray, sourceRange);
    }

    public static Segment fillCombiSegment(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        SegmentParser.fillGeneralSegment(segment, parameterMap, evaluationState);
        segment.setIsIntermediate(true);
        return segment;
    }

    public static Segment fillCodeInputSegment(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        String string;
        Segment segment2;
        SegmentParser.fillGeneralSegment(segment, parameterMap, evaluationState);
        segment.setBank(!parameterMap.exist(param_bank) ? NullValue.instance : parameterMap.getValue(param_bank));
        segment.setLoadInto(parameterMap.getStringValue(param_loadInto, ""));
        segment.setDestination(parameterMap.getStringValue(param_dest, ""));
        Integer n = parameterMap.getIntegerValue(param_align, null);
        if (n != null && n <= 0) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid align value: " + n, parameterMap.getNameRange(param_align)));
            n = null;
        }
        segment.setAlign(n);
        segment.setIsVirtual(parameterMap.getBoolValue(param_virtual, false));
        segment.setOutPrg(parameterMap.getStringValue(param_outPrg, null));
        segment.setOutBin(parameterMap.getStringValue(param_outBin, null));
        IStartResolver iStartResolver = SegmentManager.defaultStartResolver;
        if (parameterMap.exist(param_start)) {
            iStartResolver = new ConstantStartResolver(parameterMap.getIntValue(param_start), segment.getAlign());
        } else if (parameterMap.exist(param_startAfter) && (segment2 = evaluationState.segmentMgr.resolveSegment(string = parameterMap.getStringValue(param_startAfter), evaluationState, parameterMap.getNameRange(param_startAfter))) != null) {
            iStartResolver = new AfterSegmentStartResolver(segment2, segment.getAlign(), segment.getRange());
        }
        segment.setStartResolver(iStartResolver);
        return segment;
    }

    public static AnySegmentModifier resolveModifier(ParameterMap parameterMap, EvaluationState evaluationState, boolean bl) {
        AnySegmentModifier anySegmentModifier = evaluationState.resolvedSegmentModifiers.get(parameterMap);
        if (anySegmentModifier != null) {
            return anySegmentModifier;
        }
        NamespacePath namespacePath = SegmentParser.getModifyPath(parameterMap, evaluationState, bl);
        if (namespacePath == null) {
            return null;
        }
        Namespace namespace = evaluationState.namespaceMgr.resolveNSPathForExtraction(namespacePath, evaluationState);
        if (namespace == null) {
            return null;
        }
        AnySegmentModifier anySegmentModifier2 = namespace.getSegmentModifiers().get(namespacePath.entityId);
        if (anySegmentModifier2 == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Unknown modifier", namespacePath.entityIdRange));
            return null;
        }
        evaluationState.resolvedSegmentModifiers.put(parameterMap, anySegmentModifier2);
        return anySegmentModifier2;
    }

    public static void addErrorIfNotExists(ParameterMap parameterMap, Set<String> set, boolean bl, EvaluationState evaluationState) {
        parameterMap.addErrorIfNotExist(set, evaluationState);
        AnySegmentModifier anySegmentModifier = null;
        if (bl) {
            anySegmentModifier = SegmentParser.resolveModifier(parameterMap, evaluationState, false);
        }
        if (anySegmentModifier != null && anySegmentModifier.plugin != null) {
            Set<String> set2 = anySegmentModifier.plugin.getDefinition().getNonOptionalParameters();
            if (set2 == null) {
                return;
            }
            parameterMap.addErrorIfNotExist(set2, evaluationState);
        }
    }

    public static void addErrorForUnknownParameters(ParameterMap parameterMap, Set<String> set, boolean bl, EvaluationState evaluationState) {
        AnySegmentModifier anySegmentModifier;
        Set<String> set2 = null;
        if (bl) {
            anySegmentModifier = SegmentParser.resolveModifier(parameterMap, evaluationState, false);
            if (anySegmentModifier != null && anySegmentModifier.plugin != null) {
                set2 = anySegmentModifier.plugin.getDefinition().getAllParameters();
            }
            if (anySegmentModifier != null && anySegmentModifier.script != null) {
                set2 = anySegmentModifier.script.getUserArgNamesSet();
            }
        }
        if (set2 == null) {
            parameterMap.addErrorsForUnknownParameters(set, evaluationState);
            return;
        }
        anySegmentModifier = set2;
        Predicate<String> predicate = arg_0 -> SegmentParser.lambda$addErrorForUnknownParameters$0(set, (Set)((Object)anySegmentModifier), arg_0);
        parameterMap.addErrorsForUnknownParameters(predicate, evaluationState);
    }

    private static Value getConstant(ParameterMap parameterMap, String string, EvaluationState evaluationState, boolean bl) {
        ExprNode exprNode = parameterMap.getExpr(string);
        if (exprNode == null) {
            return null;
        }
        Value value = exprNode.GetConstantValue(evaluationState);
        if (value == null && bl) {
            SourceRange sourceRange = parameterMap.getNameRange(string);
            evaluationState.diagnosticMgr.add(new AsmError("'" + string + "' must be a constant expression", sourceRange));
        }
        return value;
    }

    private static NamespacePath getModifyPath(ParameterMap parameterMap, EvaluationState evaluationState, boolean bl) {
        Value value = SegmentParser.getConstant(parameterMap, param_modify, evaluationState, bl);
        if (value == null) {
            return null;
        }
        String string = value.getString(parameterMap.getNameRange(param_modify));
        if (string == null) {
            return null;
        }
        SourceRange sourceRange = parameterMap.getNameRange(param_modify);
        NamespacePath namespacePath = NamespacePathParser.parse(string, true, evaluationState, sourceRange);
        return namespacePath;
    }

    private static /* synthetic */ boolean lambda$addErrorForUnknownParameters$0(Set set, Set set2, String string) {
        return set.contains(string) || set2.contains(string);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(param_prgFiles, param_sidFiles, param_allowOverlap, param_segments, param_min, param_max, param_fill, param_fillByte, param_hide, param_modify));
        codeInputParameters = new HashSet<String>(Arrays.asList(param_start, param_startAfter, param_virtual, param_align, param_outPrg, param_outBin, param_bank, param_loadInto, param_dest));
        codeInputParameters.addAll(hashSet);
        combiParameters = new HashSet<String>();
        combiParameters.addAll(hashSet);
    }
}

