/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments.resolvers;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.segments.Segment;
import kickass.state.segments.resolvers.IStartResolver;

public class AfterSegmentStartResolver
implements IStartResolver {
    private Segment segment;
    private Integer align;
    private SourceRange range;
    boolean resolving = false;

    public AfterSegmentStartResolver(Segment segment, Integer n, SourceRange sourceRange) {
        this.segment = segment;
        this.align = n;
        this.range = sourceRange;
    }

    @Override
    public int resolve() {
        int n;
        if (this.resolving) {
            throw new AsmErrorException("Can't resolve start address. Segment '" + this.segment.getAbsoluteName() + "' is part of a circular reference.", this.range);
        }
        this.resolving = true;
        int n2 = this.segment.getResolvedEndPc();
        this.resolving = false;
        if (n2 < 0) {
            return -1;
        }
        if (this.align != null && (n = this.align - n2 % this.align) != this.align) {
            n2 += n;
        }
        return n2;
    }
}

